package com.aripd.arifxh.view;

import com.aripd.arifxh.entity.FxrateEntity;
import com.aripd.arifxh.model.LazyFxrateDataModel;
import com.aripd.arifxh.service.FxrateService;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import javax.faces.event.ActionEvent;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.chart.AxisType;
import org.primefaces.model.chart.DateAxis;
import org.primefaces.model.chart.LineChartModel;
import org.primefaces.model.chart.LineChartSeries;

@Named
@ViewScoped
public class FxrateController implements Serializable {

    static Logger logger = Logger.getLogger(FxrateController.class.getName());

    @Inject
    private FxrateService fxrateService;
    private FxrateEntity newRecord = new FxrateEntity();
    private FxrateEntity selectedRecord = new FxrateEntity();
    private List<FxrateEntity> selectedRecords;
    private LazyDataModel<FxrateEntity> lazyModel;

    private List<String> allCurrencies;
    private List<String> selectedCurrencies;
    private Date dateStart;
    private Date dateEnd;

    private LineChartModel dateModel;

    private Date mindate;
    private Date maxdate;

    public FxrateController() {
        allCurrencies = new ArrayList<>();
        selectedCurrencies = new ArrayList<>();

        // 16.04.1996 - http://www.tcmb.gov.tr/kurlar/199604/16041996.xml
        mindate = new GregorianCalendar(1996, 3, 16).getTime();
        // Now
        maxdate = Calendar.getInstance().getTime();

    }

    @PostConstruct
    public void init() {
        lazyModel = new LazyFxrateDataModel(fxrateService);

        Calendar cal = Calendar.getInstance();
        dateEnd = cal.getTime();
        cal.add(Calendar.DAY_OF_MONTH, -1);
        dateStart = cal.getTime();
        allCurrencies = fxrateService.findCurrencies();
        selectedCurrencies.add("USD");
        selectedCurrencies.add("EUR");
        selectedCurrencies.add("GBP");
        createModel();
    }

    public void doDrawChart(ActionEvent actionEvent) {
        createModel();
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Refreshed"));
    }

    private void createModel() {
        dateModel = new LineChartModel();

        DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (String currencyCode : selectedCurrencies) {
            List<FxrateEntity> items = fxrateService.findByFormModel(currencyCode, dateStart, dateEnd);
            logger.info("items size: " + items.size());
            LineChartSeries series = new LineChartSeries();
            series.setLabel(currencyCode);
            series.set(sdf.format(dateStart), 12);
            series.set(sdf.format(dateEnd), 25);
            for (FxrateEntity item : items) {
                logger.info("items label: " + item.getCurrencyDate());
                logger.info("items amount: " + item.getBanknoteSelling());
                series.set(sdf.format(item.getCurrencyDate()), item.getBanknoteSelling());
            }
            dateModel.addSeries(series);
        }

        dateModel.setTitle("Exchange Rates");
        dateModel.setLegendPosition("ne");
        dateModel.getAxis(AxisType.Y).setLabel("Exchange Rate");
        DateAxis axis = new DateAxis("Date");
        axis.setTickAngle(-50);
        axis.setTickFormat("%b %#d, %y");
        axis.setMax(sdf.format(dateEnd));

        dateModel.getAxes().put(AxisType.X, axis);
    }

    public void doFetchData(ActionEvent actionEvent) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(mindate);
        cal.add(Calendar.DATE, 111);
        Date end = cal.getTime();

        fxrateService.doFetchData(mindate, end);
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Updated"));
    }

    public void doCreateRecord(ActionEvent actionEvent) {
        fxrateService.create(newRecord);
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Created"));
    }

    public void doUpdateRecord(ActionEvent actionEvent) {
        fxrateService.update(selectedRecord);
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Updated"));
    }

    public void doDeleteRecord(ActionEvent actionEvent) {
        fxrateService.delete(selectedRecord);
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Deleted"));
    }

    public void doDeleteRecords(ActionEvent actionEvent) {
        fxrateService.deleteItems(selectedRecords);
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Deleted"));
    }

    public FxrateEntity getSelectedRecord() {
        return selectedRecord;
    }

    public void setSelectedRecord(FxrateEntity selectedRecord) {
        this.selectedRecord = selectedRecord;
    }

    public List<FxrateEntity> getSelectedRecords() {
        return selectedRecords;
    }

    public void setSelectedRecords(List<FxrateEntity> selectedRecords) {
        this.selectedRecords = selectedRecords;
    }

    public FxrateEntity getNewRecord() {
        return newRecord;
    }

    public void setNewRecord(FxrateEntity newRecord) {
        this.newRecord = newRecord;
    }

    public LazyDataModel<FxrateEntity> getLazyModel() {
        return lazyModel;
    }

    public Date getDateStart() {
        return dateStart;
    }

    public void setDateStart(Date dateStart) {
        this.dateStart = dateStart;
    }

    public Date getDateEnd() {
        return dateEnd;
    }

    public void setDateEnd(Date dateEnd) {
        this.dateEnd = dateEnd;
    }

    public LineChartModel getDateModel() {
        return dateModel;
    }

    public void setDateModel(LineChartModel dateModel) {
        this.dateModel = dateModel;
    }

    public List<String> getSelectedCurrencies() {
        return selectedCurrencies;
    }

    public void setSelectedCurrencies(List<String> selectedCurrencies) {
        this.selectedCurrencies = selectedCurrencies;
    }

    public List<String> getAllCurrencies() {
        return allCurrencies;
    }

    public void setAllCurrencies(List<String> allCurrencies) {
        this.allCurrencies = allCurrencies;
    }

    public Date getMindate() {
        return mindate;
    }

    public void setMindate(Date mindate) {
        this.mindate = mindate;
    }

    public Date getMaxdate() {
        return maxdate;
    }

    public void setMaxdate(Date maxdate) {
        this.maxdate = maxdate;
    }

}
