/*
 * Decompiled with CFR 0.152.
 */
package com.aripd.arifxh.helper;

import com.aripd.arifxh.model.FxrateDataModel;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class FxrateReader {
    static Logger logger = Logger.getLogger((String)FxrateReader.class.getName());
    private static FxrateReader instance = null;

    private FxrateReader() {
    }

    public static FxrateReader getInstance() {
        if (instance == null) {
            instance = new FxrateReader();
        }
        return instance;
    }

    public List<FxrateDataModel> getCurrencies() {
        ArrayList<FxrateDataModel> items = new ArrayList<FxrateDataModel>();
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            URL u = new URL("http://www.tcmb.gov.tr/kurlar/today.xml");
            logger.info((Object)("Fetching " + u.toString()));
            Document doc = builder.parse(u.openStream());
            String sTarih = doc.getDocumentElement().getAttribute("Date");
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
            Date Tarih_Date = sdf.parse(sTarih);
            NodeList nodes = doc.getElementsByTagName("Currency");
            for (int i = 0; i < nodes.getLength(); ++i) {
                FxrateDataModel currency = new FxrateDataModel();
                currency.setDate(Tarih_Date);
                Element element = (Element)nodes.item(i);
                currency.setCurrencyCode(element.getAttribute("CurrencyCode"));
                currency.setKod(element.getAttribute("Kod"));
                currency.setCurrencyName(this.getElementValue(element, "CurrencyName"));
                currency.setIsim(this.getElementValue(element, "Isim"));
                currency.setUnit(this.getBigDecimal(this.getElementValue(element, "Unit")));
                HashMap<FxrateDataModel.Type, BigDecimal> rates = new HashMap<FxrateDataModel.Type, BigDecimal>();
                for (FxrateDataModel.Type type : FxrateDataModel.Type.values()) {
                    rates.put(type, this.getBigDecimal(this.getElementValue(element, type.getLabel())));
                }
                currency.setRates(rates);
                items.add(currency);
            }
        }
        catch (IOException | ParseException | ParserConfigurationException | SAXException ex) {
            logger.error((Object)ex.getMessage());
        }
        return items;
    }

    public List<FxrateDataModel> getCurrenciesPrevious(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -1);
        Date previous = cal.getTime();
        return this.getCurrenciesByDate(previous);
    }

    public List<FxrateDataModel> getCurrenciesByDate(Date date) {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMM");
        SimpleDateFormat sdf2 = new SimpleDateFormat("ddMMyyyy");
        ArrayList<FxrateDataModel> items = new ArrayList<FxrateDataModel>();
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            URL u = new URL(String.format("http://www.tcmb.gov.tr/kurlar/%s/%s.xml", sdf1.format(date), sdf2.format(date)));
            logger.info((Object)("Fetching " + u.toString()));
            Document doc = builder.parse(u.openStream());
            String sTarih = doc.getDocumentElement().getAttribute("Date");
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
            Date Tarih_Date = sdf.parse(sTarih);
            NodeList nodes = doc.getElementsByTagName("Currency");
            for (int i = 0; i < nodes.getLength(); ++i) {
                FxrateDataModel currency = new FxrateDataModel();
                currency.setDate(Tarih_Date);
                Element element = (Element)nodes.item(i);
                currency.setCurrencyCode(element.getAttribute("CurrencyCode"));
                currency.setKod(element.getAttribute("Kod"));
                currency.setCurrencyName(this.getElementValue(element, "CurrencyName"));
                currency.setIsim(this.getElementValue(element, "Isim"));
                currency.setUnit(this.getBigDecimal(this.getElementValue(element, "Unit")));
                HashMap<FxrateDataModel.Type, BigDecimal> rates = new HashMap<FxrateDataModel.Type, BigDecimal>();
                for (FxrateDataModel.Type type : FxrateDataModel.Type.values()) {
                    rates.put(type, this.getBigDecimal(this.getElementValue(element, type.getLabel())));
                }
                currency.setRates(rates);
                items.add(currency);
            }
        }
        catch (IOException | ParseException | ParserConfigurationException | SAXException ex) {
            logger.error((Object)ex.getMessage());
        }
        return items;
    }

    private String getCharacterDataFromElement(Element e) {
        try {
            Node child = e.getFirstChild();
            if (child instanceof CharacterData) {
                CharacterData cd = (CharacterData)child;
                return cd.getData();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    protected BigDecimal getBigDecimal(String value) {
        if (value != null && !value.equals("") && !value.equals("(*)")) {
            return new BigDecimal(value);
        }
        return null;
    }

    protected String getElementValue(Element parent, String label) {
        return this.getCharacterDataFromElement((Element)parent.getElementsByTagName(label).item(0));
    }

    public static void main(String[] args) {
        List currencies = FxrateReader.getInstance().getCurrencies();
        System.out.println(((FxrateDataModel)currencies.get(0)).getDate());
        for (FxrateDataModel currency : currencies) {
            System.out.println(currency.getCurrencyCode() + ": " + currency.getRates().get(FxrateDataModel.Type.BanknoteSelling));
        }
    }
}

