/*
 * Decompiled with CFR 0.152.
 */
package com.aripd.arifxh.model;

import com.aripd.arifxh.entity.FxrateEntity;
import com.aripd.arifxh.service.CrudService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SortOrder;

public class LazyFxrateDataModel
extends LazyDataModel<FxrateEntity>
implements Serializable {
    private final CrudService crudService;
    private List<FxrateEntity> datasource;
    private int pageSize;
    private int rowIndex;
    private int rowCount;

    public LazyFxrateDataModel(CrudService crudService) {
        this.crudService = crudService;
    }

    public List<FxrateEntity> load(int first, int pageSize, String sortField, SortOrder sortOrder, Map<String, Object> filters) {
        this.datasource = this.crudService.getResultList(first, pageSize, sortField, sortOrder, filters);
        this.setRowCount(this.crudService.count(filters));
        return this.datasource;
    }

    public boolean isRowAvailable() {
        if (this.datasource == null) {
            return false;
        }
        int index = this.rowIndex % this.pageSize;
        return index >= 0 && index < this.datasource.size();
    }

    public Object getRowKey(FxrateEntity e) {
        return e.getId().toString();
    }

    public FxrateEntity getRowData() {
        if (this.datasource == null) {
            return null;
        }
        int index = this.rowIndex % this.pageSize;
        if (index > this.datasource.size()) {
            return null;
        }
        return (FxrateEntity)this.datasource.get(index);
    }

    public FxrateEntity getRowData(String rowKey) {
        if (this.datasource == null) {
            return null;
        }
        for (FxrateEntity e : this.datasource) {
            if (!e.getId().toString().equals(rowKey)) continue;
            return e;
        }
        return null;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }
}

