/*
 * Decompiled with CFR 0.152.
 */
package com.aripd.arifxh.service;

import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;
import org.primefaces.model.UploadedFile;

public interface CrudService<T, PK extends Serializable> {
    public T create(T var1);

    public T update(T var1);

    public void delete(T var1);

    public boolean deleteItems(List<T> var1);

    public T find(PK var1);

    public List<T> findAll();

    public List<T> findAllUsingPagination(int var1, int var2);

    public List<T> findRange(int[] var1);

    public List findWithNamedQuery(String var1);

    public List findWithNamedQuery(String var1, Map var2);

    public List findWithNamedQuery(String var1, int var2);

    public List<T> findByNativeQuery(String var1);

    public List<T> findWithNamedQuery(String var1, Map var2, int var3);

    public List<T> findWithNamedQuery(String var1, int var2, int var3);

    public int count();

    public int countTotalRecord(String var1);

    public Predicate getFilterCondition(CriteriaBuilder var1, Root<T> var2, Map<String, Object> var3);

    public int count(Map<String, Object> var1);

    public List<T> getResultList(int var1, int var2, String var3, SortOrder var4, Map<String, Object> var5);

    public List<T> getResultList(int var1, int var2, List<SortMeta> var3, Map<String, Object> var4);

    public BufferedImage convert(BufferedImage var1, int var2, int var3);

    public void writeBais(String var1, byte[] var2);

    public String uploadToLocal(String var1, UploadedFile var2);

    public boolean removeFromLocal(String var1, String var2);

    default public void doSomeOtherWork() {
        System.out.println("DoSomeOtherWork implementation in the interface");
    }

    default public Path getUploadPath(String directory) {
        return Paths.get(System.getProperty("user.home"), "Developments", "backup", "filestack", directory);
    }
}

