/*
 * Decompiled with CFR 0.152.
 */
package com.aripd.arifxh.service;

import com.aripd.arifxh.service.CrudService;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.imageio.ImageIO;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.log4j.Logger;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;
import org.primefaces.model.UploadedFile;

public abstract class CrudServiceBean<T, PK extends Serializable>
implements CrudService<T, PK> {
    static Logger logger = Logger.getLogger((String)CrudServiceBean.class.getName());
    private final Class<T> persistentClass;

    public CrudServiceBean(Class<T> entityClass) {
        this.persistentClass = entityClass;
    }

    protected abstract EntityManager getEntityManager();

    public T create(T entity) {
        this.getEntityManager().persist(entity);
        this.getEntityManager().flush();
        return entity;
    }

    public T update(T entity) {
        Object updated = this.getEntityManager().merge(entity);
        return (T)updated;
    }

    public void delete(T entity) {
        this.getEntityManager().remove(this.getEntityManager().merge(entity));
    }

    public boolean deleteItems(List<T> entities) {
        entities.stream().forEach(entity -> this.getEntityManager().remove(this.getEntityManager().merge(entity)));
        return true;
    }

    public T find(PK id) {
        return (T)this.getEntityManager().find(this.persistentClass, id);
    }

    public List<T> findAll() {
        CriteriaQuery cq = this.getEntityManager().getCriteriaBuilder().createQuery();
        cq.select((Selection)cq.from(this.persistentClass));
        return this.getEntityManager().createQuery(cq).getResultList();
    }

    public List<T> findAllUsingPagination(int pageNumber, int pageSize) {
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery countQuery = cb.createQuery(Long.class);
        countQuery.select((Selection)cb.count((Expression)countQuery.from(this.persistentClass)));
        Long count = (Long)this.getEntityManager().createQuery(countQuery).getSingleResult();
        CriteriaQuery cq = cb.createQuery(this.persistentClass);
        Root root = cq.from(this.persistentClass);
        CriteriaQuery select = cq.select((Selection)root);
        TypedQuery typedQuery = this.getEntityManager().createQuery(select);
        typedQuery.setFirstResult((pageNumber - 1) * pageSize);
        typedQuery.setMaxResults(pageSize);
        List list = typedQuery.getResultList();
        return list;
    }

    public List<T> findRange(int[] range) {
        CriteriaQuery cq = this.getEntityManager().getCriteriaBuilder().createQuery();
        cq.select((Selection)cq.from(this.persistentClass));
        TypedQuery query = this.getEntityManager().createQuery(cq);
        query.setMaxResults(range[1] - range[0]);
        query.setFirstResult(range[0]);
        return query.getResultList();
    }

    public List findWithNamedQuery(String namedQueryName) {
        return this.getEntityManager().createNamedQuery(namedQueryName).getResultList();
    }

    public List findWithNamedQuery(String namedQueryName, Map parameters) {
        return this.findWithNamedQuery(namedQueryName, parameters, 0);
    }

    public List findWithNamedQuery(String queryName, int resultLimit) {
        return this.getEntityManager().createNamedQuery(queryName).setMaxResults(resultLimit).getResultList();
    }

    public List<T> findByNativeQuery(String sql) {
        return this.getEntityManager().createNativeQuery(sql, this.persistentClass).getResultList();
    }

    public List<T> findWithNamedQuery(String namedQueryName, Map parameters, int resultLimit) {
        Set rawParameters = parameters.entrySet();
        Query query = this.getEntityManager().createNamedQuery(namedQueryName);
        if (resultLimit > 0) {
            query.setMaxResults(resultLimit);
        }
        for (Map.Entry entry : rawParameters) {
            query.setParameter((String)entry.getKey(), entry.getValue());
        }
        return query.getResultList();
    }

    public List<T> findWithNamedQuery(String namedQueryName, int start, int end) {
        Query query = this.getEntityManager().createNamedQuery(namedQueryName);
        query.setMaxResults(end - start);
        query.setFirstResult(start);
        return query.getResultList();
    }

    public int count() {
        CriteriaQuery cq = this.getEntityManager().getCriteriaBuilder().createQuery();
        Root root = cq.from(this.persistentClass);
        cq.select((Selection)this.getEntityManager().getCriteriaBuilder().count((Expression)root));
        TypedQuery query = this.getEntityManager().createQuery(cq);
        return ((Long)query.getSingleResult()).intValue();
    }

    public int countTotalRecord(String namedQueryName) {
        Query query = this.getEntityManager().createNamedQuery(namedQueryName);
        Number result = (Number)query.getSingleResult();
        return result.intValue();
    }

    public Predicate getFilterCondition(CriteriaBuilder cb, Root<T> root, Map<String, Object> filters) {
        Predicate filterCondition = cb.conjunction();
        if (filters != null) {
            String wildCard = "%";
            for (Map.Entry<String, Object> filter : filters.entrySet()) {
                String value = wildCard + filter.getValue() + wildCard;
                if (filter.getValue().equals("")) continue;
                javax.persistence.criteria.Path path = root.get(filter.getKey());
                filterCondition = cb.and((Expression)filterCondition, (Expression)cb.like((Expression)path, value));
            }
        }
        return filterCondition;
    }

    public int count(Map<String, Object> filters) {
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery();
        Root root = cq.from(this.persistentClass);
        cq.where((Expression)this.getFilterCondition(cb, root, filters));
        cq.select((Selection)this.getEntityManager().getCriteriaBuilder().count((Expression)root));
        TypedQuery query = this.getEntityManager().createQuery(cq);
        return ((Long)query.getSingleResult()).intValue();
    }

    public List<T> getResultList(int first, int pageSize, String sortField, SortOrder sortOrder, Map<String, Object> filters) {
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery();
        Root root = cq.from(this.persistentClass);
        cq.select((Selection)root);
        cq.where((Expression)this.getFilterCondition(cb, root, filters));
        if (sortField != null) {
            if (sortOrder == SortOrder.ASCENDING) {
                cq.orderBy(new Order[]{cb.asc((Expression)root.get(sortField))});
            } else if (sortOrder == SortOrder.DESCENDING) {
                cq.orderBy(new Order[]{cb.desc((Expression)root.get(sortField))});
            }
        }
        TypedQuery query = this.getEntityManager().createQuery(cq);
        return query.setFirstResult(first).setMaxResults(pageSize).getResultList();
    }

    public List<T> getResultList(int first, int pageSize, List<SortMeta> multiSortMeta, Map<String, Object> filters) {
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery();
        Root root = cq.from(this.persistentClass);
        cq.select((Selection)root);
        cq.where((Expression)this.getFilterCondition(cb, root, filters));
        if (multiSortMeta != null) {
            ArrayList<Order> orders = new ArrayList<Order>();
            for (SortMeta sortMeta : multiSortMeta) {
                String sortField = sortMeta.getSortField();
                SortOrder sortOrder = sortMeta.getSortOrder();
                if (sortField == null) continue;
                Order order = null;
                if (sortOrder == SortOrder.ASCENDING) {
                    order = cb.asc((Expression)root.get(sortField));
                } else if (sortOrder == SortOrder.DESCENDING) {
                    order = cb.desc((Expression)root.get(sortField));
                }
                orders.add(order);
            }
            cq.orderBy(orders);
        }
        TypedQuery query = this.getEntityManager().createQuery(cq);
        return query.setFirstResult(first).setMaxResults(pageSize).getResultList();
    }

    public BufferedImage convert(BufferedImage originalImage, int width, int height) {
        BufferedImage converted = new BufferedImage(width, height, 8);
        Graphics2D g = converted.createGraphics();
        g.drawImage(originalImage, 0, 0, width, height, null);
        g.dispose();
        return converted;
    }

    public void writeBais(String filePath, byte[] buf) {
        try {
            BufferedImage originalImage = ImageIO.read(new ByteArrayInputStream(buf));
            BufferedImage newImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 5);
            for (int x = 0; x < originalImage.getWidth(); ++x) {
                for (int y = 0; y < originalImage.getHeight(); ++y) {
                    newImage.setRGB(x, y, originalImage.getRGB(x, y));
                }
            }
            ImageIO.write((RenderedImage)newImage, "jpeg", new File(filePath));
        }
        catch (IOException ex) {
            throw new FacesException("Error in writing image.", (Throwable)ex);
        }
    }

    public String uploadToLocal(String directory, UploadedFile uploadedFile) {
        try {
            Path path = Files.createTempFile(this.getUploadPath(directory), "somefilename-", ".jpg", new FileAttribute[0]);
            try (InputStream inputStream = uploadedFile.getInputstream();){
                Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
            }
            String fileName = path.getFileName().toString();
            return fileName;
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            return "";
        }
    }

    public boolean removeFromLocal(String directory, String fileName) {
        try {
            return Files.deleteIfExists(this.getUploadPath(directory).resolve(fileName));
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            return false;
        }
    }
}

