/*
 * Decompiled with CFR 0.152.
 */
package com.aripd.arifxh.service;

import com.aripd.arifxh.entity.FxrateEntity;
import com.aripd.arifxh.entity.FxrateEntity_;
import com.aripd.arifxh.helper.FxrateReader;
import com.aripd.arifxh.model.FxrateDataModel;
import com.aripd.arifxh.service.CrudServiceBean;
import com.aripd.arifxh.service.FxrateService;
import com.aripd.arifxh.util.DateIterator;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

@Stateless
public class FxrateServiceBean
extends CrudServiceBean<FxrateEntity, Long>
implements FxrateService {
    @PersistenceContext
    private EntityManager em;

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public FxrateServiceBean() {
        super(FxrateEntity.class);
    }

    public FxrateEntity findOneByDateAndCode(Date date, String currencyCode) {
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(FxrateEntity.class);
        Root root = cq.from(FxrateEntity.class);
        Predicate predicate1 = cb.equal((Expression)root.get(FxrateEntity_.currencyDate), (Object)date);
        Predicate predicate2 = cb.equal((Expression)root.get(FxrateEntity_.currencyCode), (Object)currencyCode);
        Predicate predicate = cb.and((Expression)predicate1, (Expression)predicate2);
        cq.where((Expression)predicate);
        TypedQuery q = this.getEntityManager().createQuery(cq);
        List results = q.getResultList();
        FxrateEntity entity = null;
        if (!results.isEmpty()) {
            entity = (FxrateEntity)results.get(0);
        }
        return entity;
    }

    public List<FxrateEntity> findByCurrencyCode(String currencyCode) {
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(FxrateEntity.class);
        Root root = cq.from(FxrateEntity.class);
        Predicate predicate = cb.equal((Expression)root.get(FxrateEntity_.currencyCode), (Object)currencyCode);
        cq.where((Expression)predicate);
        TypedQuery q = this.getEntityManager().createQuery(cq);
        return q.getResultList();
    }

    public List<FxrateEntity> findByDate(Date date) {
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(FxrateEntity.class);
        Root root = cq.from(FxrateEntity.class);
        Predicate predicate = cb.equal((Expression)root.get(FxrateEntity_.currencyDate), (Object)date);
        cq.where((Expression)predicate);
        TypedQuery q = this.getEntityManager().createQuery(cq);
        return q.getResultList();
    }

    public void doSaveData(FxrateDataModel model) {
        String code;
        Date date = model.getDate();
        FxrateEntity fxrate = this.findOneByDateAndCode(date, code = model.getKod());
        if (fxrate == null) {
            FxrateEntity f = new FxrateEntity();
            f.setCurrencyDate(date);
            f.setCurrencyCode(code);
            f.setUnit(model.getUnit());
            f.setForexBuying((BigDecimal)model.getRates().get(FxrateDataModel.Type.ForexBuying));
            f.setForexSelling((BigDecimal)model.getRates().get(FxrateDataModel.Type.ForexSelling));
            f.setBanknoteBuying((BigDecimal)model.getRates().get(FxrateDataModel.Type.BanknoteBuying));
            f.setBanknoteSelling((BigDecimal)model.getRates().get(FxrateDataModel.Type.BanknoteSelling));
            this.create((Object)f);
        }
    }

    public void doFetchData(Date date) {
        List currencies = FxrateReader.getInstance().getCurrenciesByDate(date);
        for (FxrateDataModel model : currencies) {
            this.doSaveData(model);
        }
    }

    public void doFetchData(Date start, Date end) {
        DateIterator i = new DateIterator(start, end);
        while (i.hasNext()) {
            Date date = (Date)i.next();
            this.doFetchData(date);
        }
    }

    public List<FxrateEntity> findByFormModel(String currencyCode, Date dateStart, Date dateEnd) {
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(FxrateEntity.class);
        Root root = cq.from(FxrateEntity.class);
        Predicate predicate1 = cb.equal((Expression)root.get(FxrateEntity_.currencyCode), (Object)currencyCode);
        Predicate predicate2 = cb.between((Expression)root.get(FxrateEntity_.currencyDate), (Comparable)dateStart, (Comparable)dateEnd);
        Predicate predicate = cb.and((Expression)predicate1, (Expression)predicate2);
        cq.where((Expression)predicate);
        TypedQuery q = this.getEntityManager().createQuery(cq);
        return q.getResultList();
    }

    public List<String> findCurrencies() {
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(String.class);
        Root root = cq.from(FxrateEntity.class);
        cq.select((Selection)root.get(FxrateEntity_.currencyCode)).distinct(true);
        TypedQuery query = this.getEntityManager().createQuery(cq);
        return query.getResultList();
    }
}

