/*
 * Decompiled with CFR 0.152.
 */
package com.aripd.arifxh.view;

import com.aripd.arifxh.helper.FxrateReader;
import com.aripd.arifxh.model.FxrateDataModel;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

@Named
@ViewScoped
public class FxrateBean
implements Serializable {
    private List<FxrateDataModel> current;
    private Date date;
    private List<FxrateDataModel> previous;

    @PostConstruct
    public void init() {
        this.current = FxrateReader.getInstance().getCurrencies();
        this.date = ((FxrateDataModel)this.current.get(0)).getDate();
        this.previous = FxrateReader.getInstance().getCurrenciesPrevious(this.date);
    }

    public BigDecimal cur(String code) {
        for (FxrateDataModel m : this.current) {
            if (!m.getCurrencyCode().equals(code)) continue;
            return (BigDecimal)m.getRates().get(FxrateDataModel.Type.BanknoteSelling);
        }
        return null;
    }

    public BigDecimal pre(String code) {
        for (FxrateDataModel m : this.previous) {
            if (!m.getCurrencyCode().equals(code)) continue;
            return (BigDecimal)m.getRates().get(FxrateDataModel.Type.BanknoteSelling);
        }
        return null;
    }

    public BigDecimal change(String code) {
        BigDecimal cur = this.cur(code);
        BigDecimal pre = this.pre(code);
        return cur.subtract(pre).divide(pre, RoundingMode.HALF_UP);
    }

    public List<FxrateDataModel> getCurrent() {
        return this.current;
    }

    public Date getDate() {
        return this.date;
    }

    public List<FxrateDataModel> getPrevious() {
        return this.previous;
    }
}

