/*
 * Decompiled with CFR 0.152.
 */
package com.aripd.arifxh.view;

import com.aripd.arifxh.entity.FxrateEntity;
import com.aripd.arifxh.model.LazyFxrateDataModel;
import com.aripd.arifxh.service.CrudService;
import com.aripd.arifxh.service.FxrateService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.chart.AxisType;
import org.primefaces.model.chart.ChartSeries;
import org.primefaces.model.chart.DateAxis;
import org.primefaces.model.chart.LineChartModel;
import org.primefaces.model.chart.LineChartSeries;

@Named
@ViewScoped
public class FxrateController
implements Serializable {
    static Logger logger = Logger.getLogger((String)FxrateController.class.getName());
    @Inject
    private FxrateService fxrateService;
    private FxrateEntity newRecord = new FxrateEntity();
    private FxrateEntity selectedRecord = new FxrateEntity();
    private List<FxrateEntity> selectedRecords;
    private LazyDataModel<FxrateEntity> lazyModel;
    private List<String> allCurrencies = new ArrayList();
    private List<String> selectedCurrencies = new ArrayList();
    private Date dateStart;
    private Date dateEnd;
    private LineChartModel dateModel;
    private Date mindate = new GregorianCalendar(1996, 3, 16).getTime();
    private Date maxdate = Calendar.getInstance().getTime();

    @PostConstruct
    public void init() {
        this.lazyModel = new LazyFxrateDataModel((CrudService)this.fxrateService);
        Calendar cal = Calendar.getInstance();
        this.dateEnd = cal.getTime();
        cal.add(5, -1);
        this.dateStart = cal.getTime();
        this.allCurrencies = this.fxrateService.findCurrencies();
        this.selectedCurrencies.add("USD");
        this.selectedCurrencies.add("EUR");
        this.selectedCurrencies.add("GBP");
        this.createModel();
    }

    public void doDrawChart(ActionEvent actionEvent) {
        this.createModel();
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Refreshed"));
    }

    private void createModel() {
        this.dateModel = new LineChartModel();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (String currencyCode : this.selectedCurrencies) {
            List items = this.fxrateService.findByFormModel(currencyCode, this.dateStart, this.dateEnd);
            logger.info((Object)("items size: " + items.size()));
            LineChartSeries series = new LineChartSeries();
            series.setLabel(currencyCode);
            series.set((Object)sdf.format(this.dateStart), (Number)12);
            series.set((Object)sdf.format(this.dateEnd), (Number)25);
            for (FxrateEntity item : items) {
                logger.info((Object)("items label: " + item.getCurrencyDate()));
                logger.info((Object)("items amount: " + item.getBanknoteSelling()));
                series.set((Object)sdf.format(item.getCurrencyDate()), (Number)item.getBanknoteSelling());
            }
            this.dateModel.addSeries((ChartSeries)series);
        }
        this.dateModel.setTitle("Exchange Rates");
        this.dateModel.setLegendPosition("ne");
        this.dateModel.getAxis(AxisType.Y).setLabel("Exchange Rate");
        DateAxis axis = new DateAxis("Date");
        axis.setTickAngle(-50);
        axis.setTickFormat("%b %#d, %y");
        axis.setMax((Object)sdf.format(this.dateEnd));
        this.dateModel.getAxes().put(AxisType.X, axis);
    }

    public void doFetchData(ActionEvent actionEvent) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.mindate);
        cal.add(5, 111);
        Date end = cal.getTime();
        this.fxrateService.doFetchData(this.mindate, end);
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Updated"));
    }

    public void doCreateRecord(ActionEvent actionEvent) {
        this.fxrateService.create((Object)this.newRecord);
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Created"));
    }

    public void doUpdateRecord(ActionEvent actionEvent) {
        this.fxrateService.update((Object)this.selectedRecord);
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Updated"));
    }

    public void doDeleteRecord(ActionEvent actionEvent) {
        this.fxrateService.delete((Object)this.selectedRecord);
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Deleted"));
    }

    public void doDeleteRecords(ActionEvent actionEvent) {
        this.fxrateService.deleteItems(this.selectedRecords);
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Deleted"));
    }

    public FxrateEntity getSelectedRecord() {
        return this.selectedRecord;
    }

    public void setSelectedRecord(FxrateEntity selectedRecord) {
        this.selectedRecord = selectedRecord;
    }

    public List<FxrateEntity> getSelectedRecords() {
        return this.selectedRecords;
    }

    public void setSelectedRecords(List<FxrateEntity> selectedRecords) {
        this.selectedRecords = selectedRecords;
    }

    public FxrateEntity getNewRecord() {
        return this.newRecord;
    }

    public void setNewRecord(FxrateEntity newRecord) {
        this.newRecord = newRecord;
    }

    public LazyDataModel<FxrateEntity> getLazyModel() {
        return this.lazyModel;
    }

    public Date getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(Date dateStart) {
        this.dateStart = dateStart;
    }

    public Date getDateEnd() {
        return this.dateEnd;
    }

    public void setDateEnd(Date dateEnd) {
        this.dateEnd = dateEnd;
    }

    public LineChartModel getDateModel() {
        return this.dateModel;
    }

    public void setDateModel(LineChartModel dateModel) {
        this.dateModel = dateModel;
    }

    public List<String> getSelectedCurrencies() {
        return this.selectedCurrencies;
    }

    public void setSelectedCurrencies(List<String> selectedCurrencies) {
        this.selectedCurrencies = selectedCurrencies;
    }

    public List<String> getAllCurrencies() {
        return this.allCurrencies;
    }

    public void setAllCurrencies(List<String> allCurrencies) {
        this.allCurrencies = allCurrencies;
    }

    public Date getMindate() {
        return this.mindate;
    }

    public void setMindate(Date mindate) {
        this.mindate = mindate;
    }

    public Date getMaxdate() {
        return this.maxdate;
    }

    public void setMaxdate(Date maxdate) {
        this.maxdate = maxdate;
    }
}

