/*
 * Decompiled with CFR 0.152.
 */
package com.arize.semconv.trace;

public class SemanticConventions {
    public static final String INPUT_VALUE = "input.value";
    public static final String INPUT_MIME_TYPE = "input.mime_type";
    public static final String OUTPUT_VALUE = "output.value";
    public static final String OUTPUT_MIME_TYPE = "output.mime_type";
    public static final String LLM_INPUT_MESSAGES = "llm.input_messages";
    public static final String LLM_OUTPUT_MESSAGES = "llm.output_messages";
    public static final String LLM_MODEL_NAME = "llm.model_name";
    public static final String RETRIEVAL_DOCUMENTS = "retrieval.documents";
    public static final String MESSAGE_ROLE = "message.role";
    public static final String MESSAGE_CONTENT = "message.content";
    public static final String LLM_PROMPTS = "llm.prompts";
    public static final String LLM_INVOCATION_PARAMETERS = "llm.invocation_parameters";
    public static final String LLM_PROVIDER = "llm.provider";
    public static final String LLM_SYSTEM = "llm.system";
    public static final String LLM_TOKEN_COUNT_COMPLETION = "llm.token_count.completion";
    public static final String LLM_TOKEN_COUNT_COMPLETION_DETAILS_REASONING = "llm.token_count.completion_details.reasoning";
    public static final String LLM_TOKEN_COUNT_COMPLETION_DETAILS_AUDIO = "llm.token_count.completion_details.audio";
    public static final String LLM_TOKEN_COUNT_PROMPT = "llm.token_count.prompt";
    public static final String LLM_TOKEN_COUNT_PROMPT_DETAILS_CACHE_WRITE = "llm.token_count.prompt_details.cache_write";
    public static final String LLM_TOKEN_COUNT_PROMPT_DETAILS_CACHE_READ = "llm.token_count.prompt_details.cache_read";
    public static final String LLM_TOKEN_COUNT_PROMPT_DETAILS_AUDIO = "llm.token_count.prompt_details.audio";
    public static final String LLM_TOKEN_COUNT_TOTAL = "llm.token_count.total";
    public static final String LLM_TOKEN_COUNT_PROMPT_DETAILS = "llm.token_count.prompt_details";
    public static final String LLM_TOKEN_COUNT_COMPLETION_DETAILS = "llm.token_count.completion_details";
    public static final String LLM_COST = "llm.cost";
    public static final String LLM_COST_PROMPT = "llm.cost.prompt";
    public static final String LLM_COST_COMPLETION = "llm.cost.completion";
    public static final String LLM_COST_TOTAL = "llm.cost.total";
    public static final String LLM_COST_INPUT = "llm.cost.prompt_details.input";
    public static final String LLM_COST_OUTPUT = "llm.cost.completion_details.output";
    public static final String LLM_COST_COMPLETION_DETAILS_REASONING = "llm.cost.completion_details.reasoning";
    public static final String LLM_COST_COMPLETION_DETAILS_AUDIO = "llm.cost.completion_details.audio";
    public static final String LLM_COST_PROMPT_DETAILS_CACHE_WRITE = "llm.cost.prompt_details.cache_write";
    public static final String LLM_COST_PROMPT_DETAILS_CACHE_READ = "llm.cost.prompt_details.cache_read";
    public static final String LLM_COST_PROMPT_DETAILS_CACHE_INPUT = "llm.cost.prompt_details.cache_input";
    public static final String LLM_COST_PROMPT_DETAILS_AUDIO = "llm.cost.prompt_details.audio";
    public static final String MESSAGE_NAME = "message.name";
    public static final String MESSAGE_TOOL_CALLS = "message.tool_calls";
    public static final String MESSAGE_TOOL_CALL_ID = "message.tool_call_id";
    public static final String TOOL_CALL_FUNCTION_NAME = "tool_call.function.name";
    public static final String TOOL_CALL_FUNCTION_ARGUMENTS_JSON = "tool_call.function.arguments";
    public static final String TOOL_CALL_ID = "tool_call.id";
    public static final String MESSAGE_FUNCTION_CALL_NAME = "message.function_call_name";
    public static final String MESSAGE_FUNCTION_CALL_ARGUMENTS_JSON = "message.function_call_arguments_json";
    public static final String MESSAGE_CONTENTS = "message.contents";
    public static final String MESSAGE_CONTENT_TYPE = "message_content.type";
    public static final String MESSAGE_CONTENT_TEXT = "message_content.text";
    public static final String MESSAGE_CONTENT_IMAGE = "message_content.image";
    public static final String IMAGE_URL = "image.url";
    public static final String DOCUMENT_ID = "document.id";
    public static final String DOCUMENT_CONTENT = "document.content";
    public static final String DOCUMENT_SCORE = "document.score";
    public static final String DOCUMENT_METADATA = "document.metadata";
    public static final String EMBEDDING_TEXT = "embedding.text";
    public static final String EMBEDDING_MODEL_NAME = "embedding.model_name";
    public static final String EMBEDDING_VECTOR = "embedding.vector";
    public static final String EMBEDDING_EMBEDDINGS = "embedding.embeddings";
    private static final String PROMPT_TEMPLATE_PREFIX = "llm.prompt_template";
    public static final String PROMPT_TEMPLATE_VARIABLES = "llm.prompt_template.variables";
    public static final String PROMPT_TEMPLATE_TEMPLATE = "llm.prompt_template.template";
    public static final String PROMPT_TEMPLATE_VERSION = "llm.prompt_template.version";
    public static final String LLM_FUNCTION_CALL = "llm.function_call";
    public static final String LLM_TOOLS = "llm.tools";
    public static final String TOOL_NAME = "tool.name";
    public static final String TOOL_DESCRIPTION = "tool.description";
    public static final String TOOL_PARAMETERS = "tool.parameters";
    public static final String TOOL_JSON_SCHEMA = "tool.json_schema";
    public static final String SESSION_ID = "session.id";
    public static final String USER_ID = "user.id";
    public static final String RERANKER_INPUT_DOCUMENTS = "reranker.input_documents";
    public static final String RERANKER_OUTPUT_DOCUMENTS = "reranker.output_documents";
    public static final String RERANKER_QUERY = "reranker.query";
    public static final String RERANKER_MODEL_NAME = "reranker.model_name";
    public static final String RERANKER_TOP_K = "reranker.top_k";
    public static final String METADATA = "metadata";
    public static final String TAG_TAGS = "tag.tags";
    public static final String AUDIO_URL = "audio.url";
    public static final String AUDIO_MIME_TYPE = "audio.mime_type";
    public static final String AUDIO_TRANSCRIPT = "audio.transcript";
    public static final String PROMPT_VENDOR = "prompt.vendor";
    public static final String PROMPT_ID = "prompt.id";
    public static final String PROMPT_URL = "prompt.url";
    public static final String AGENT_NAME = "agent.name";
    public static final String GRAPH_NODE_ID = "graph.node.id";
    public static final String GRAPH_NODE_NAME = "graph.node.name";
    public static final String GRAPH_NODE_PARENT_ID = "graph.node.parent_id";
    public static final String OPENINFERENCE_SPAN_KIND = "openinference.span.kind";

    public static final class SemanticAttributePrefixes {
        public static final String INPUT = "input";
        public static final String OUTPUT = "output";
        public static final String LLM = "llm";
        public static final String RETRIEVAL = "retrieval";
        public static final String RERANKER = "reranker";
        public static final String MESSAGES = "messages";
        public static final String MESSAGE = "message";
        public static final String DOCUMENT = "document";
        public static final String EMBEDDING = "embedding";
        public static final String TOOL = "tool";
        public static final String TOOL_CALL = "tool_call";
        public static final String METADATA = "metadata";
        public static final String TAG = "tag";
        public static final String SESSION = "session";
        public static final String USER = "user";
        public static final String OPENINFERENCE = "openinference";
        public static final String MESSAGE_CONTENT = "message_content";
        public static final String IMAGE = "image";
        public static final String AUDIO = "audio";
        public static final String PROMPT = "prompt";
        public static final String AGENT = "agent";
        public static final String GRAPH = "graph";

        private SemanticAttributePrefixes() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class LLMAttributePostfixes {
        public static final String PROVIDER = "provider";
        public static final String SYSTEM = "system";
        public static final String MODEL_NAME = "model_name";
        public static final String TOKEN_COUNT = "token_count";
        public static final String INPUT_MESSAGES = "input_messages";
        public static final String OUTPUT_MESSAGES = "output_messages";
        public static final String INVOCATION_PARAMETERS = "invocation_parameters";
        public static final String PROMPTS = "prompts";
        public static final String PROMPT_TEMPLATE = "prompt_template";
        public static final String FUNCTION_CALL = "function_call";
        public static final String TOOLS = "tools";
        public static final String COST = "cost";

        private LLMAttributePostfixes() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class RetrievalAttributePostfixes {
        public static final String DOCUMENTS = "documents";

        private RetrievalAttributePostfixes() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class MessageAttributePostfixes {
        public static final String ROLE = "role";
        public static final String CONTENT = "content";
        public static final String CONTENTS = "contents";
        public static final String NAME = "name";
        public static final String FUNCTION_CALL_NAME = "function_call_name";
        public static final String FUNCTION_CALL_ARGUMENTS_JSON = "function_call_arguments_json";
        public static final String TOOL_CALLS = "tool_calls";
        public static final String TOOL_CALL_ID = "tool_call_id";

        private MessageAttributePostfixes() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class ToolCallAttributePostfixes {
        public static final String FUNCTION_NAME = "function.name";
        public static final String FUNCTION_ARGUMENTS = "function.arguments";
        public static final String ID = "id";

        private ToolCallAttributePostfixes() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class MessageContentsAttributePostfixes {
        public static final String TYPE = "type";
        public static final String TEXT = "text";
        public static final String IMAGE = "image";

        private MessageContentsAttributePostfixes() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class ImageAttributesPostfixes {
        public static final String URL = "url";

        private ImageAttributesPostfixes() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class DocumentAttributePostfixes {
        public static final String ID = "id";
        public static final String CONTENT = "content";
        public static final String SCORE = "score";
        public static final String METADATA = "metadata";

        private DocumentAttributePostfixes() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class EmbeddingAttributePostfixes {
        public static final String EMBEDDINGS = "embeddings";
        public static final String TEXT = "text";
        public static final String MODEL_NAME = "model_name";
        public static final String VECTOR = "vector";

        private EmbeddingAttributePostfixes() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class ToolAttributePostfixes {
        public static final String NAME = "name";
        public static final String DESCRIPTION = "description";
        public static final String PARAMETERS = "parameters";
        public static final String JSON_SCHEMA = "json_schema";

        private ToolAttributePostfixes() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class SessionAttributePostfixes {
        public static final String ID = "id";

        private SessionAttributePostfixes() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class UserAttributePostfixes {
        public static final String ID = "id";

        private UserAttributePostfixes() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class RerankerAttributePostfixes {
        public static final String INPUT_DOCUMENTS = "input_documents";
        public static final String OUTPUT_DOCUMENTS = "output_documents";
        public static final String QUERY = "query";
        public static final String MODEL_NAME = "model_name";
        public static final String TOP_K = "top_k";

        private RerankerAttributePostfixes() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class TagAttributePostfixes {
        public static final String TAGS = "tags";

        private TagAttributePostfixes() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class AudioAttributesPostfixes {
        public static final String URL = "url";
        public static final String MIME_TYPE = "mime_type";
        public static final String TRANSCRIPT = "transcript";

        private AudioAttributesPostfixes() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class PromptAttributePostfixes {
        public static final String VENDOR = "vendor";
        public static final String ID = "id";
        public static final String URL = "url";

        private PromptAttributePostfixes() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class AgentPostfixes {
        public static final String NAME = "name";

        private AgentPostfixes() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class GraphPostfixes {
        public static final String NODE_ID = "node.id";
        public static final String NODE_NAME = "node.name";
        public static final String NODE_PARENT_ID = "node.parent_id";

        private GraphPostfixes() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static enum LLMProvider {
        OPENAI("openai"),
        ANTHROPIC("anthropic"),
        MISTRALAI("mistralai"),
        COHERE("cohere"),
        GOOGLE("google"),
        AWS("aws"),
        AZURE("azure"),
        XAI("xai"),
        DEEPSEEK("deepseek");

        private final String value;

        private LLMProvider(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum LLMSystem {
        OPENAI("openai"),
        ANTHROPIC("anthropic"),
        MISTRALAI("mistralai"),
        COHERE("cohere"),
        VERTEXAI("vertexai");

        private final String value;

        private LLMSystem(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum MimeType {
        TEXT("text/plain"),
        JSON("application/json"),
        AUDIO_WAV("audio/wav");

        private final String value;

        private MimeType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum OpenInferenceSpanKind {
        LLM("LLM"),
        CHAIN("CHAIN"),
        TOOL("TOOL"),
        RETRIEVER("RETRIEVER"),
        RERANKER("RERANKER"),
        EMBEDDING("EMBEDDING"),
        AGENT("AGENT"),
        GUARDRAIL("GUARDRAIL"),
        EVALUATOR("EVALUATOR");

        private final String value;

        private OpenInferenceSpanKind(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static final class LLMPromptTemplateAttributePostfixes {
        public static final String VARIABLES = "variables";
        public static final String TEMPLATE = "template";

        private LLMPromptTemplateAttributePostfixes() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

