/*
 * Decompiled with CFR 0.152.
 */
package com.arkivanov.essenty.statekeeper.base64;

import com.arkivanov.essenty.statekeeper.base64.DictionariesKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0002H\u0000\u00a8\u0006\u0005"}, d2={"base64ToByteArray", "", "", "decode", "encoded", "state-keeper_release"})
@SourceDebugExtension(value={"SMAP\nDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Decoder.kt\ncom/arkivanov/essenty/statekeeper/base64/DecoderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class DecoderKt {
    @NotNull
    public static final byte[] base64ToByteArray(@NotNull String $this$base64ToByteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$base64ToByteArray, (String)"<this>");
        return DecoderKt.decode($this$base64ToByteArray);
    }

    @NotNull
    public static final byte[] decode(@NotNull String encoded) {
        byte[] byArray;
        int n;
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        if (StringsKt.isBlank((CharSequence)encoded)) {
            return new byte[0];
        }
        byte[] result = new byte[encoded.length()];
        int resultSize = 0;
        int[] backDictionary = DictionariesKt.getBackDictionary();
        int buffer = 0;
        int buffered = 0;
        int index = 0;
        while (index < encoded.length()) {
            int n2;
            char ch;
            if (Intrinsics.compare((int)(ch = encoded.charAt(index++)), (int)32) <= 0) continue;
            if (ch == '=') {
                --index;
                break;
            }
            int[] nArray = backDictionary;
            char c = ch;
            boolean bl = '\u0000' <= c ? c < nArray.length : false;
            if (bl) {
                n2 = nArray[c];
            } else {
                char it = c;
                boolean bl2 = false;
                n2 = -1;
            }
            int value = n2;
            if (value == -1) {
                throw new IllegalStateException(("Unexpected character " + ch + " (" + ch + ")) in " + encoded).toString());
            }
            buffer = buffer << 6 | value;
            n = buffered;
            if ((buffered = n + 1) != 4) continue;
            result[resultSize] = (byte)(buffer >> 16);
            result[resultSize + 1] = (byte)(buffer >> 8 & 0xFF);
            result[resultSize + 2] = (byte)(buffer & 0xFF);
            resultSize += 3;
            buffered = 0;
            buffer = 0;
        }
        int padding = 0;
        while (index < encoded.length()) {
            char ch;
            if (Intrinsics.compare((int)(ch = encoded.charAt(index++)), (int)32) <= 0) continue;
            if (!(ch == '=')) {
                throw new IllegalStateException("Check failed.");
            }
            ++padding;
            buffer <<= 6;
            n = buffered;
            buffered = n + 1;
        }
        if (buffered == 4) {
            result[resultSize] = (byte)(buffer >> 16);
            result[resultSize + 1] = (byte)(buffer >> 8 & 0xFF);
            result[resultSize + 2] = (byte)(buffer & 0xFF);
            resultSize += 3;
            resultSize -= padding;
            buffered = 0;
        }
        if (!(buffered == 0)) {
            boolean bl = false;
            String string = "buffered: " + buffered;
            throw new IllegalStateException(string.toString());
        }
        if (resultSize < result.length) {
            byte[] byArray2 = Arrays.copyOf(result, resultSize);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
        } else {
            byArray = result;
        }
        return byArray;
    }
}

