package com.arkivanov.mvikotlin.core.view

import com.arkivanov.mvikotlin.core.annotations.MainThread
import com.arkivanov.mvikotlin.core.rx.Disposable
import com.arkivanov.mvikotlin.core.rx.Observer
import com.arkivanov.mvikotlin.core.rx.internal.PublishSubject
import kotlin.js.JsName

/**
 * Abstract implementation of the [MviView] that provides ability to dispatch `View Events`
 */
open class BaseMviView<in Model : Any, Event : Any> : MviView<Model, Event> {

    protected open val renderer: ViewRenderer<Model>? = null
    private val subject = PublishSubject<Event>()

    override fun events(observer: Observer<Event>): Disposable = subject.subscribe(observer)

    /**
     * Dispatches the provided `View Event` to all subscribers
     *
     * @param event a `View Event` to be dispatched
     */
    @JsName("dispatch")
    @MainThread
    fun dispatch(event: Event) {
        subject.onNext(event)
    }

    override fun render(model: Model) {
        renderer?.render(model)
    }
}
