/*
 * Decompiled with CFR 0.152.
 */
package com.arronlong.httpclientutil.builder;

import com.arronlong.httpclientutil.common.SSLs;
import com.arronlong.httpclientutil.exception.HttpProcessException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

public class HCB
extends HttpClientBuilder {
    public boolean isSetPool = false;
    private SSLs.SSLProtocolVersion sslpv = SSLs.SSLProtocolVersion.SSLv3;
    private SSLs ssls = SSLs.getInstance();

    private HCB() {
    }

    public static HCB custom() {
        return new HCB();
    }

    @Deprecated
    public HCB timeout(int timeout) {
        return this.timeout(timeout, true);
    }

    @Deprecated
    public HCB timeout(int timeout, boolean redirectEnable) {
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(timeout).setConnectTimeout(timeout).setSocketTimeout(timeout).setRedirectsEnabled(redirectEnable).build();
        return (HCB)this.setDefaultRequestConfig(config);
    }

    public HCB ssl() throws HttpProcessException {
        return (HCB)this.setSSLSocketFactory((LayeredConnectionSocketFactory)this.ssls.getSSLCONNSF(this.sslpv));
    }

    public HCB ssl(String keyStorePath) throws HttpProcessException {
        return this.ssl(keyStorePath, "nopassword");
    }

    public HCB ssl(String keyStorePath, String keyStorepass) throws HttpProcessException {
        this.ssls = SSLs.custom().customSSL(keyStorePath, keyStorepass);
        return this.ssl();
    }

    public HCB pool(int maxTotal, int defaultMaxPerRoute) throws HttpProcessException {
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)this.ssls.getSSLCONNSF(this.sslpv)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connManager.setMaxTotal(maxTotal);
        connManager.setDefaultMaxPerRoute(defaultMaxPerRoute);
        this.isSetPool = true;
        return (HCB)this.setConnectionManager((HttpClientConnectionManager)connManager);
    }

    public HCB proxy(String hostOrIP, int port) {
        HttpHost proxy = new HttpHost(hostOrIP, port, "http");
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
        return (HCB)this.setRoutePlanner((HttpRoutePlanner)routePlanner);
    }

    public HCB retry(int tryTimes) {
        return this.retry(tryTimes, false);
    }

    public HCB retry(final int tryTimes, final boolean retryWhenInterruptedIO) {
        HttpRequestRetryHandler httpRequestRetryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount >= tryTimes) {
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    return true;
                }
                if (exception instanceof SSLHandshakeException) {
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    return retryWhenInterruptedIO;
                }
                if (exception instanceof UnknownHostException) {
                    return true;
                }
                if (exception instanceof ConnectTimeoutException) {
                    return false;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                HttpRequest request = clientContext.getRequest();
                return !(request instanceof HttpEntityEnclosingRequest);
            }
        };
        this.setRetryHandler(httpRequestRetryHandler);
        return this;
    }

    public HCB sslpv(String sslpv) {
        return this.sslpv(SSLs.SSLProtocolVersion.find(sslpv));
    }

    public HCB sslpv(SSLs.SSLProtocolVersion sslpv) {
        this.sslpv = sslpv;
        return this;
    }
}

