/*
 * Decompiled with CFR 0.152.
 */
package com.arthurivanets.googleplayscraper;

import com.arthurivanets.googleplayscraper.GooglePlayRequestInterceptor;
import com.arthurivanets.googleplayscraper.GooglePlayScraper;
import com.arthurivanets.googleplayscraper.NoRequestThrottling;
import com.arthurivanets.googleplayscraper.RequestThrottler;
import com.arthurivanets.googleplayscraper.ResourceFileUserAgentProvider;
import com.arthurivanets.googleplayscraper.Specs;
import com.arthurivanets.googleplayscraper.UserAgentProvider;
import com.arthurivanets.googleplayscraper.model.App;
import com.arthurivanets.googleplayscraper.model.AppDetails;
import com.arthurivanets.googleplayscraper.model.AppReview;
import com.arthurivanets.googleplayscraper.model.Permission;
import com.arthurivanets.googleplayscraper.modelfactories.AppDetailsModelFactory;
import com.arthurivanets.googleplayscraper.modelfactories.AppModelFactory;
import com.arthurivanets.googleplayscraper.modelfactories.AppReviewModelFactory;
import com.arthurivanets.googleplayscraper.parsers.AppDetailsResultParser;
import com.arthurivanets.googleplayscraper.parsers.AppReviewsResultParser;
import com.arthurivanets.googleplayscraper.parsers.AppSearchResultParser;
import com.arthurivanets.googleplayscraper.parsers.AppsClusterUrlResultParser;
import com.arthurivanets.googleplayscraper.parsers.AppsResultParser;
import com.arthurivanets.googleplayscraper.parsers.PermissionsResultParser;
import com.arthurivanets.googleplayscraper.requests.DefaultAppsLoadingRequestFactory;
import com.arthurivanets.googleplayscraper.requests.GetAppDetailsParams;
import com.arthurivanets.googleplayscraper.requests.GetAppDetailsRequest;
import com.arthurivanets.googleplayscraper.requests.GetAppPermissionsParams;
import com.arthurivanets.googleplayscraper.requests.GetAppPermissionsRequest;
import com.arthurivanets.googleplayscraper.requests.GetAppReviewsParams;
import com.arthurivanets.googleplayscraper.requests.GetAppReviewsRequest;
import com.arthurivanets.googleplayscraper.requests.GetAppsParams;
import com.arthurivanets.googleplayscraper.requests.GetAppsRequest;
import com.arthurivanets.googleplayscraper.requests.GetDeveloperAppsParams;
import com.arthurivanets.googleplayscraper.requests.GetDeveloperAppsRequest;
import com.arthurivanets.googleplayscraper.requests.GetSimilarAppsParams;
import com.arthurivanets.googleplayscraper.requests.GetSimilarAppsRequest;
import com.arthurivanets.googleplayscraper.requests.Request;
import com.arthurivanets.googleplayscraper.requests.RequestParamsValidator;
import com.arthurivanets.googleplayscraper.requests.SearchAppsParams;
import com.arthurivanets.googleplayscraper.requests.SearchAppsRequest;
import com.arthurivanets.googleplayscraper.specs.AppReviewSpec;
import com.arthurivanets.googleplayscraper.specs.AppReviewsResponseSpec;
import com.arthurivanets.googleplayscraper.specs.AppSearchResponseSpec;
import com.arthurivanets.googleplayscraper.specs.AppSpec;
import com.arthurivanets.googleplayscraper.specs.AppsResponseSpec;
import com.arthurivanets.googleplayscraper.util.AppsResponseJsonExtractor;
import com.arthurivanets.googleplayscraper.util.DefaultResponseJsonExtractor;
import com.arthurivanets.googleplayscraper.util.DefaultScriptDataParser;
import com.arthurivanets.googleplayscraper.util.IterativeJsonNormalizer;
import com.arthurivanets.googleplayscraper.util.JsonPathProcessor;
import com.google.gson.Gson;
import java.time.Duration;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 w2\u00020\u0001:\u0002wxB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010a\u001a\u00020DH\u0002J\u0014\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0006\u0010e\u001a\u00020fJ\u001a\u0010g\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020i0h0c2\u0006\u0010e\u001a\u00020jJ\u001a\u0010k\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020l0h0c2\u0006\u0010e\u001a\u00020mJ\u001a\u0010n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020o0h0c2\u0006\u0010e\u001a\u00020pJ\u001a\u0010q\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020o0h0c2\u0006\u0010e\u001a\u00020rJ\u001a\u0010s\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020o0h0c2\u0006\u0010e\u001a\u00020tJ\u001a\u0010u\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020o0h0c2\u0006\u0010e\u001a\u00020vR\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\n\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\n\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\n\u001a\u0004\b!\u0010\"R\u001b\u0010$\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\n\u001a\u0004\b%\u0010\"R\u001b\u0010'\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\n\u001a\u0004\b(\u0010\"R\u001b\u0010*\u001a\u00020+8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\n\u001a\u0004\b,\u0010-R\u001b\u0010/\u001a\u0002008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010\n\u001a\u0004\b1\u00102R\u001b\u00104\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010\n\u001a\u0004\b5\u0010\"R\u001b\u00107\u001a\u0002088BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010\n\u001a\u0004\b9\u0010:R\u000e\u0010<\u001a\u00020=X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010>\u001a\u00020?8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u0010\n\u001a\u0004\b@\u0010AR\u001b\u0010C\u001a\u00020D8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bG\u0010\n\u001a\u0004\bE\u0010FR\u001b\u0010H\u001a\u00020I8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bL\u0010\n\u001a\u0004\bJ\u0010KR\u001b\u0010M\u001a\u00020N8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bQ\u0010\n\u001a\u0004\bO\u0010PR\u001b\u0010R\u001a\u00020S8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bV\u0010\n\u001a\u0004\bT\u0010UR\u001b\u0010W\u001a\u00020X8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b[\u0010\n\u001a\u0004\bY\u0010ZR\u001b\u0010\\\u001a\u00020]8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b`\u0010\n\u001a\u0004\b^\u0010_\u00a8\u0006y"}, d2={"Lcom/arthurivanets/googleplayscraper/GooglePlayScraper;", "", "config", "Lcom/arthurivanets/googleplayscraper/GooglePlayScraper$Config;", "(Lcom/arthurivanets/googleplayscraper/GooglePlayScraper$Config;)V", "appDetailsResultParser", "Lcom/arthurivanets/googleplayscraper/parsers/AppDetailsResultParser;", "getAppDetailsResultParser", "()Lcom/arthurivanets/googleplayscraper/parsers/AppDetailsResultParser;", "appDetailsResultParser$delegate", "Lkotlin/Lazy;", "appModelFactory", "Lcom/arthurivanets/googleplayscraper/modelfactories/AppModelFactory;", "getAppModelFactory", "()Lcom/arthurivanets/googleplayscraper/modelfactories/AppModelFactory;", "appModelFactory$delegate", "appReviewModelFactory", "Lcom/arthurivanets/googleplayscraper/modelfactories/AppReviewModelFactory;", "getAppReviewModelFactory", "()Lcom/arthurivanets/googleplayscraper/modelfactories/AppReviewModelFactory;", "appReviewModelFactory$delegate", "appReviewsRequestResultParser", "Lcom/arthurivanets/googleplayscraper/parsers/AppReviewsResultParser;", "getAppReviewsRequestResultParser", "()Lcom/arthurivanets/googleplayscraper/parsers/AppReviewsResultParser;", "appReviewsRequestResultParser$delegate", "appsClusterUrlResultParser", "Lcom/arthurivanets/googleplayscraper/parsers/AppsClusterUrlResultParser;", "getAppsClusterUrlResultParser", "()Lcom/arthurivanets/googleplayscraper/parsers/AppsClusterUrlResultParser;", "appsClusterUrlResultParser$delegate", "appsDevIdNanInitialRequestResultParser", "Lcom/arthurivanets/googleplayscraper/parsers/AppsResultParser;", "getAppsDevIdNanInitialRequestResultParser", "()Lcom/arthurivanets/googleplayscraper/parsers/AppsResultParser;", "appsDevIdNanInitialRequestResultParser$delegate", "appsInitialRequestResultParser", "getAppsInitialRequestResultParser", "appsInitialRequestResultParser$delegate", "appsListingRequestResultParser", "getAppsListingRequestResultParser", "appsListingRequestResultParser$delegate", "appsLoadingRequestFactory", "Lcom/arthurivanets/googleplayscraper/requests/DefaultAppsLoadingRequestFactory;", "getAppsLoadingRequestFactory", "()Lcom/arthurivanets/googleplayscraper/requests/DefaultAppsLoadingRequestFactory;", "appsLoadingRequestFactory$delegate", "appsResponseJsonExtractor", "Lcom/arthurivanets/googleplayscraper/util/AppsResponseJsonExtractor;", "getAppsResponseJsonExtractor", "()Lcom/arthurivanets/googleplayscraper/util/AppsResponseJsonExtractor;", "appsResponseJsonExtractor$delegate", "appsResultParser", "getAppsResultParser", "appsResultParser$delegate", "appsSearchInitialRequestResultParser", "Lcom/arthurivanets/googleplayscraper/parsers/AppSearchResultParser;", "getAppsSearchInitialRequestResultParser", "()Lcom/arthurivanets/googleplayscraper/parsers/AppSearchResultParser;", "appsSearchInitialRequestResultParser$delegate", "baseUrl", "", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "gson$delegate", "httpClient", "Lokhttp3/OkHttpClient;", "getHttpClient", "()Lokhttp3/OkHttpClient;", "httpClient$delegate", "jsonNormalizer", "Lcom/arthurivanets/googleplayscraper/util/IterativeJsonNormalizer;", "getJsonNormalizer", "()Lcom/arthurivanets/googleplayscraper/util/IterativeJsonNormalizer;", "jsonNormalizer$delegate", "pathProcessor", "Lcom/arthurivanets/googleplayscraper/util/JsonPathProcessor;", "getPathProcessor", "()Lcom/arthurivanets/googleplayscraper/util/JsonPathProcessor;", "pathProcessor$delegate", "permissionsResultParser", "Lcom/arthurivanets/googleplayscraper/parsers/PermissionsResultParser;", "getPermissionsResultParser", "()Lcom/arthurivanets/googleplayscraper/parsers/PermissionsResultParser;", "permissionsResultParser$delegate", "requestParamsValidator", "Lcom/arthurivanets/googleplayscraper/requests/RequestParamsValidator;", "getRequestParamsValidator", "()Lcom/arthurivanets/googleplayscraper/requests/RequestParamsValidator;", "requestParamsValidator$delegate", "responseJsonExtractor", "Lcom/arthurivanets/googleplayscraper/util/DefaultResponseJsonExtractor;", "getResponseJsonExtractor", "()Lcom/arthurivanets/googleplayscraper/util/DefaultResponseJsonExtractor;", "responseJsonExtractor$delegate", "createHttpClient", "getAppDetails", "Lcom/arthurivanets/googleplayscraper/requests/Request;", "Lcom/arthurivanets/googleplayscraper/model/AppDetails;", "params", "Lcom/arthurivanets/googleplayscraper/requests/GetAppDetailsParams;", "getAppPermissions", "", "Lcom/arthurivanets/googleplayscraper/model/Permission;", "Lcom/arthurivanets/googleplayscraper/requests/GetAppPermissionsParams;", "getAppReviews", "Lcom/arthurivanets/googleplayscraper/model/AppReview;", "Lcom/arthurivanets/googleplayscraper/requests/GetAppReviewsParams;", "getApps", "Lcom/arthurivanets/googleplayscraper/model/App;", "Lcom/arthurivanets/googleplayscraper/requests/GetAppsParams;", "getDeveloperApps", "Lcom/arthurivanets/googleplayscraper/requests/GetDeveloperAppsParams;", "getSimilarApps", "Lcom/arthurivanets/googleplayscraper/requests/GetSimilarAppsParams;", "searchApps", "Lcom/arthurivanets/googleplayscraper/requests/SearchAppsParams;", "Companion", "Config", "google-play-scraper"})
public final class GooglePlayScraper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Config config;
    @NotNull
    private final String baseUrl;
    @NotNull
    private final Lazy httpClient$delegate;
    @NotNull
    private final Lazy gson$delegate;
    @NotNull
    private final Lazy pathProcessor$delegate;
    @NotNull
    private final Lazy appModelFactory$delegate;
    @NotNull
    private final Lazy appReviewModelFactory$delegate;
    @NotNull
    private final Lazy jsonNormalizer$delegate;
    @NotNull
    private final Lazy responseJsonExtractor$delegate;
    @NotNull
    private final Lazy appsResponseJsonExtractor$delegate;
    @NotNull
    private final Lazy appsLoadingRequestFactory$delegate;
    @NotNull
    private final Lazy appsClusterUrlResultParser$delegate;
    @NotNull
    private final Lazy appsInitialRequestResultParser$delegate;
    @NotNull
    private final Lazy appsSearchInitialRequestResultParser$delegate;
    @NotNull
    private final Lazy appsDevIdNanInitialRequestResultParser$delegate;
    @NotNull
    private final Lazy appsResultParser$delegate;
    @NotNull
    private final Lazy appsListingRequestResultParser$delegate;
    @NotNull
    private final Lazy appDetailsResultParser$delegate;
    @NotNull
    private final Lazy permissionsResultParser$delegate;
    @NotNull
    private final Lazy appReviewsRequestResultParser$delegate;
    @NotNull
    private final Lazy requestParamsValidator$delegate;
    private static final Duration HTTP_CONNECT_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration HTTP_READ_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration HTTP_WRITE_TIMEOUT = Duration.ofSeconds(60L);

    public GooglePlayScraper(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.baseUrl = "https://play.google.com";
        this.httpClient$delegate = LazyKt.lazy((Function0)((Function0)new Function0<OkHttpClient>((Object)this){

            @NotNull
            public final OkHttpClient invoke() {
                return GooglePlayScraper.access$createHttpClient((GooglePlayScraper)this.receiver);
            }
        }));
        this.gson$delegate = LazyKt.lazy((Function0)gson.2.INSTANCE);
        this.pathProcessor$delegate = LazyKt.lazy((Function0)pathProcessor.2.INSTANCE);
        this.appModelFactory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AppModelFactory>(this){
            final /* synthetic */ GooglePlayScraper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AppModelFactory invoke() {
                return new AppModelFactory(GooglePlayScraper.access$getBaseUrl$p(this.this$0), GooglePlayScraper.access$getPathProcessor(this.this$0));
            }
        }));
        this.appReviewModelFactory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AppReviewModelFactory>(this){
            final /* synthetic */ GooglePlayScraper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AppReviewModelFactory invoke() {
                return new AppReviewModelFactory(GooglePlayScraper.access$getPathProcessor(this.this$0));
            }
        }));
        this.jsonNormalizer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IterativeJsonNormalizer>(this){
            final /* synthetic */ GooglePlayScraper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IterativeJsonNormalizer invoke() {
                return new IterativeJsonNormalizer(GooglePlayScraper.access$getGson(this.this$0));
            }
        }));
        this.responseJsonExtractor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DefaultResponseJsonExtractor>(this){
            final /* synthetic */ GooglePlayScraper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DefaultResponseJsonExtractor invoke() {
                return new DefaultResponseJsonExtractor(GooglePlayScraper.access$getGson(this.this$0), new DefaultScriptDataParser(GooglePlayScraper.access$getGson(this.this$0)), GooglePlayScraper.access$getJsonNormalizer(this.this$0));
            }
        }));
        this.appsResponseJsonExtractor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AppsResponseJsonExtractor>(this){
            final /* synthetic */ GooglePlayScraper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AppsResponseJsonExtractor invoke() {
                return new AppsResponseJsonExtractor(GooglePlayScraper.access$getGson(this.this$0), GooglePlayScraper.access$getJsonNormalizer(this.this$0), GooglePlayScraper.access$getResponseJsonExtractor(this.this$0));
            }
        }));
        this.appsLoadingRequestFactory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DefaultAppsLoadingRequestFactory>(this){
            final /* synthetic */ GooglePlayScraper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DefaultAppsLoadingRequestFactory invoke() {
                return new DefaultAppsLoadingRequestFactory(GooglePlayScraper.access$getBaseUrl$p(this.this$0));
            }
        }));
        this.appsClusterUrlResultParser$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AppsClusterUrlResultParser>(this){
            final /* synthetic */ GooglePlayScraper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AppsClusterUrlResultParser invoke() {
                return new AppsClusterUrlResultParser(Specs.INSTANCE.getCLUSTER_URL(), GooglePlayScraper.access$getResponseJsonExtractor(this.this$0), GooglePlayScraper.access$getPathProcessor(this.this$0));
            }
        }));
        this.appsInitialRequestResultParser$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AppsResultParser>(this){
            final /* synthetic */ GooglePlayScraper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AppsResultParser invoke() {
                AppsResponseSpec appsResponseSpec = Specs.INSTANCE.getAPPS_INITIAL_RESPONSE();
                AppSpec appSpec = Specs.INSTANCE.getAPP_INITIAL_REQUEST();
                JsonPathProcessor jsonPathProcessor = GooglePlayScraper.access$getPathProcessor(this.this$0);
                AppModelFactory appModelFactory2 = GooglePlayScraper.access$getAppModelFactory(this.this$0);
                AppsResponseJsonExtractor appsResponseJsonExtractor2 = GooglePlayScraper.access$getAppsResponseJsonExtractor(this.this$0);
                return new AppsResultParser(appsResponseSpec, appSpec, appsResponseJsonExtractor2, jsonPathProcessor, appModelFactory2);
            }
        }));
        this.appsSearchInitialRequestResultParser$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AppSearchResultParser>(this){
            final /* synthetic */ GooglePlayScraper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AppSearchResultParser invoke() {
                AppSearchResponseSpec appSearchResponseSpec = Specs.INSTANCE.getAPP_SEARCH_INITIAL_RESPONSE();
                AppSpec appSpec = Specs.INSTANCE.getAPP_SEARCH_FEATURED();
                AppSpec appSpec2 = Specs.INSTANCE.getAPP_SEARCH();
                JsonPathProcessor jsonPathProcessor = GooglePlayScraper.access$getPathProcessor(this.this$0);
                AppModelFactory appModelFactory2 = GooglePlayScraper.access$getAppModelFactory(this.this$0);
                AppsResponseJsonExtractor appsResponseJsonExtractor2 = GooglePlayScraper.access$getAppsResponseJsonExtractor(this.this$0);
                return new AppSearchResultParser(appSearchResponseSpec, appSpec, appSpec2, appsResponseJsonExtractor2, jsonPathProcessor, appModelFactory2);
            }
        }));
        this.appsDevIdNanInitialRequestResultParser$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AppsResultParser>(this){
            final /* synthetic */ GooglePlayScraper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AppsResultParser invoke() {
                AppsResponseSpec appsResponseSpec = Specs.INSTANCE.getAPPS_DEV_ID_NAN_INITIAL_RESPONSE();
                AppSpec appSpec = Specs.INSTANCE.getAPP_DEV_ID_NAN();
                JsonPathProcessor jsonPathProcessor = GooglePlayScraper.access$getPathProcessor(this.this$0);
                AppModelFactory appModelFactory2 = GooglePlayScraper.access$getAppModelFactory(this.this$0);
                AppsResponseJsonExtractor appsResponseJsonExtractor2 = GooglePlayScraper.access$getAppsResponseJsonExtractor(this.this$0);
                return new AppsResultParser(appsResponseSpec, appSpec, appsResponseJsonExtractor2, jsonPathProcessor, appModelFactory2);
            }
        }));
        this.appsResultParser$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AppsResultParser>(this){
            final /* synthetic */ GooglePlayScraper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AppsResultParser invoke() {
                AppsResponseSpec appsResponseSpec = Specs.INSTANCE.getAPPS_RESPONSE();
                AppSpec appSpec = Specs.INSTANCE.getAPP();
                JsonPathProcessor jsonPathProcessor = GooglePlayScraper.access$getPathProcessor(this.this$0);
                AppModelFactory appModelFactory2 = GooglePlayScraper.access$getAppModelFactory(this.this$0);
                AppsResponseJsonExtractor appsResponseJsonExtractor2 = GooglePlayScraper.access$getAppsResponseJsonExtractor(this.this$0);
                return new AppsResultParser(appsResponseSpec, appSpec, appsResponseJsonExtractor2, jsonPathProcessor, appModelFactory2);
            }
        }));
        this.appsListingRequestResultParser$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AppsResultParser>(this){
            final /* synthetic */ GooglePlayScraper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AppsResultParser invoke() {
                AppsResponseSpec appsResponseSpec = Specs.INSTANCE.getAPPS_LISTING_RESPONSE();
                AppSpec appSpec = Specs.INSTANCE.getAPP_LISTING();
                JsonPathProcessor jsonPathProcessor = GooglePlayScraper.access$getPathProcessor(this.this$0);
                AppModelFactory appModelFactory2 = GooglePlayScraper.access$getAppModelFactory(this.this$0);
                AppsResponseJsonExtractor appsResponseJsonExtractor2 = GooglePlayScraper.access$getAppsResponseJsonExtractor(this.this$0);
                return new AppsResultParser(appsResponseSpec, appSpec, appsResponseJsonExtractor2, jsonPathProcessor, appModelFactory2);
            }
        }));
        this.appDetailsResultParser$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AppDetailsResultParser>(this){
            final /* synthetic */ GooglePlayScraper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AppDetailsResultParser invoke() {
                return new AppDetailsResultParser(Specs.INSTANCE.getAPP_DETAILS(), GooglePlayScraper.access$getResponseJsonExtractor(this.this$0), new AppDetailsModelFactory(GooglePlayScraper.access$getPathProcessor(this.this$0)));
            }
        }));
        this.permissionsResultParser$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PermissionsResultParser>(this){
            final /* synthetic */ GooglePlayScraper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PermissionsResultParser invoke() {
                return new PermissionsResultParser(GooglePlayScraper.access$getPathProcessor(this.this$0), GooglePlayScraper.access$getResponseJsonExtractor(this.this$0), Specs.INSTANCE.getPERMISSIONS_RESPONSE());
            }
        }));
        this.appReviewsRequestResultParser$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AppReviewsResultParser>(this){
            final /* synthetic */ GooglePlayScraper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AppReviewsResultParser invoke() {
                AppReviewsResponseSpec appReviewsResponseSpec = Specs.INSTANCE.getAPP_REVIEWS_RESPONSE();
                AppReviewSpec appReviewSpec = Specs.INSTANCE.getAPP_REVIEW();
                JsonPathProcessor jsonPathProcessor = GooglePlayScraper.access$getPathProcessor(this.this$0);
                AppReviewModelFactory appReviewModelFactory2 = GooglePlayScraper.access$getAppReviewModelFactory(this.this$0);
                DefaultResponseJsonExtractor defaultResponseJsonExtractor = GooglePlayScraper.access$getResponseJsonExtractor(this.this$0);
                return new AppReviewsResultParser(appReviewsResponseSpec, appReviewSpec, defaultResponseJsonExtractor, jsonPathProcessor, appReviewModelFactory2);
            }
        }));
        this.requestParamsValidator$delegate = LazyKt.lazy((Function0)requestParamsValidator.2.INSTANCE);
    }

    public /* synthetic */ GooglePlayScraper(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = new Config(null, null, 3, null);
        }
        this(config);
    }

    private final OkHttpClient getHttpClient() {
        Lazy lazy = this.httpClient$delegate;
        return (OkHttpClient)lazy.getValue();
    }

    private final Gson getGson() {
        Lazy lazy = this.gson$delegate;
        return (Gson)lazy.getValue();
    }

    private final JsonPathProcessor getPathProcessor() {
        Lazy lazy = this.pathProcessor$delegate;
        return (JsonPathProcessor)lazy.getValue();
    }

    private final AppModelFactory getAppModelFactory() {
        Lazy lazy = this.appModelFactory$delegate;
        return (AppModelFactory)lazy.getValue();
    }

    private final AppReviewModelFactory getAppReviewModelFactory() {
        Lazy lazy = this.appReviewModelFactory$delegate;
        return (AppReviewModelFactory)lazy.getValue();
    }

    private final IterativeJsonNormalizer getJsonNormalizer() {
        Lazy lazy = this.jsonNormalizer$delegate;
        return (IterativeJsonNormalizer)lazy.getValue();
    }

    private final DefaultResponseJsonExtractor getResponseJsonExtractor() {
        Lazy lazy = this.responseJsonExtractor$delegate;
        return (DefaultResponseJsonExtractor)lazy.getValue();
    }

    private final AppsResponseJsonExtractor getAppsResponseJsonExtractor() {
        Lazy lazy = this.appsResponseJsonExtractor$delegate;
        return (AppsResponseJsonExtractor)lazy.getValue();
    }

    private final DefaultAppsLoadingRequestFactory getAppsLoadingRequestFactory() {
        Lazy lazy = this.appsLoadingRequestFactory$delegate;
        return (DefaultAppsLoadingRequestFactory)lazy.getValue();
    }

    private final AppsClusterUrlResultParser getAppsClusterUrlResultParser() {
        Lazy lazy = this.appsClusterUrlResultParser$delegate;
        return (AppsClusterUrlResultParser)lazy.getValue();
    }

    private final AppsResultParser getAppsInitialRequestResultParser() {
        Lazy lazy = this.appsInitialRequestResultParser$delegate;
        return (AppsResultParser)lazy.getValue();
    }

    private final AppSearchResultParser getAppsSearchInitialRequestResultParser() {
        Lazy lazy = this.appsSearchInitialRequestResultParser$delegate;
        return (AppSearchResultParser)lazy.getValue();
    }

    private final AppsResultParser getAppsDevIdNanInitialRequestResultParser() {
        Lazy lazy = this.appsDevIdNanInitialRequestResultParser$delegate;
        return (AppsResultParser)lazy.getValue();
    }

    private final AppsResultParser getAppsResultParser() {
        Lazy lazy = this.appsResultParser$delegate;
        return (AppsResultParser)lazy.getValue();
    }

    private final AppsResultParser getAppsListingRequestResultParser() {
        Lazy lazy = this.appsListingRequestResultParser$delegate;
        return (AppsResultParser)lazy.getValue();
    }

    private final AppDetailsResultParser getAppDetailsResultParser() {
        Lazy lazy = this.appDetailsResultParser$delegate;
        return (AppDetailsResultParser)lazy.getValue();
    }

    private final PermissionsResultParser getPermissionsResultParser() {
        Lazy lazy = this.permissionsResultParser$delegate;
        return (PermissionsResultParser)lazy.getValue();
    }

    private final AppReviewsResultParser getAppReviewsRequestResultParser() {
        Lazy lazy = this.appReviewsRequestResultParser$delegate;
        return (AppReviewsResultParser)lazy.getValue();
    }

    private final RequestParamsValidator getRequestParamsValidator() {
        Lazy lazy = this.requestParamsValidator$delegate;
        return (RequestParamsValidator)lazy.getValue();
    }

    @NotNull
    public final Request<AppDetails> getAppDetails(@NotNull GetAppDetailsParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.getRequestParamsValidator().validate(params);
        return new GetAppDetailsRequest(params, this.baseUrl, this.getHttpClient(), this.getAppDetailsResultParser());
    }

    @NotNull
    public final Request<List<App>> getDeveloperApps(@NotNull GetDeveloperAppsParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.getRequestParamsValidator().validate(params);
        boolean isDevIdNumeric = StringsKt.toLongOrNull((String)params.getDevId()) != null;
        return new GetDeveloperAppsRequest(params, this.baseUrl, this.getHttpClient(), this.getAppsLoadingRequestFactory(), isDevIdNumeric ? this.getAppsInitialRequestResultParser() : this.getAppsDevIdNanInitialRequestResultParser(), this.getAppsResultParser());
    }

    @NotNull
    public final Request<List<App>> getSimilarApps(@NotNull GetSimilarAppsParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.getRequestParamsValidator().validate(params);
        return new GetSimilarAppsRequest(params, this.baseUrl, this.getHttpClient(), this.getAppsLoadingRequestFactory(), this.getAppsClusterUrlResultParser(), this.getAppsInitialRequestResultParser(), this.getAppsResultParser());
    }

    @NotNull
    public final Request<List<App>> getApps(@NotNull GetAppsParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.getRequestParamsValidator().validate(params);
        return new GetAppsRequest(params, this.baseUrl, this.getHttpClient(), this.getAppsListingRequestResultParser());
    }

    @NotNull
    public final Request<List<App>> searchApps(@NotNull SearchAppsParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.getRequestParamsValidator().validate(params);
        return new SearchAppsRequest(params, this.baseUrl, this.getHttpClient(), this.getAppsLoadingRequestFactory(), this.getAppsSearchInitialRequestResultParser(), this.getAppsResultParser());
    }

    @NotNull
    public final Request<List<Permission>> getAppPermissions(@NotNull GetAppPermissionsParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.getRequestParamsValidator().validate(params);
        return new GetAppPermissionsRequest(params, this.baseUrl, this.getHttpClient(), this.getPermissionsResultParser());
    }

    @NotNull
    public final Request<List<AppReview>> getAppReviews(@NotNull GetAppReviewsParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.getRequestParamsValidator().validate(params);
        return new GetAppReviewsRequest(params, this.baseUrl, this.getHttpClient(), this.getAppReviewsRequestResultParser());
    }

    private final OkHttpClient createHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().addInterceptor((Interceptor)new GooglePlayRequestInterceptor(this.config.getThrottler(), this.config.getUserAgentProvider()));
        Duration duration = HTTP_CONNECT_TIMEOUT;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"HTTP_CONNECT_TIMEOUT");
        OkHttpClient.Builder builder2 = builder.connectTimeout(duration);
        duration = HTTP_READ_TIMEOUT;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"HTTP_READ_TIMEOUT");
        OkHttpClient.Builder builder3 = builder2.readTimeout(duration);
        duration = HTTP_WRITE_TIMEOUT;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"HTTP_WRITE_TIMEOUT");
        return builder3.writeTimeout(duration).build();
    }

    public GooglePlayScraper() {
        this(null, 1, null);
    }

    public static final /* synthetic */ OkHttpClient access$createHttpClient(GooglePlayScraper $this) {
        return $this.createHttpClient();
    }

    public static final /* synthetic */ String access$getBaseUrl$p(GooglePlayScraper $this) {
        return $this.baseUrl;
    }

    public static final /* synthetic */ JsonPathProcessor access$getPathProcessor(GooglePlayScraper $this) {
        return $this.getPathProcessor();
    }

    public static final /* synthetic */ Gson access$getGson(GooglePlayScraper $this) {
        return $this.getGson();
    }

    public static final /* synthetic */ IterativeJsonNormalizer access$getJsonNormalizer(GooglePlayScraper $this) {
        return $this.getJsonNormalizer();
    }

    public static final /* synthetic */ DefaultResponseJsonExtractor access$getResponseJsonExtractor(GooglePlayScraper $this) {
        return $this.getResponseJsonExtractor();
    }

    public static final /* synthetic */ AppModelFactory access$getAppModelFactory(GooglePlayScraper $this) {
        return $this.getAppModelFactory();
    }

    public static final /* synthetic */ AppsResponseJsonExtractor access$getAppsResponseJsonExtractor(GooglePlayScraper $this) {
        return $this.getAppsResponseJsonExtractor();
    }

    public static final /* synthetic */ AppReviewModelFactory access$getAppReviewModelFactory(GooglePlayScraper $this) {
        return $this.getAppReviewModelFactory();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/arthurivanets/googleplayscraper/GooglePlayScraper$Config;", "", "throttler", "Lcom/arthurivanets/googleplayscraper/RequestThrottler;", "userAgentProvider", "Lcom/arthurivanets/googleplayscraper/UserAgentProvider;", "(Lcom/arthurivanets/googleplayscraper/RequestThrottler;Lcom/arthurivanets/googleplayscraper/UserAgentProvider;)V", "getThrottler", "()Lcom/arthurivanets/googleplayscraper/RequestThrottler;", "getUserAgentProvider", "()Lcom/arthurivanets/googleplayscraper/UserAgentProvider;", "google-play-scraper"})
    public static final class Config {
        @NotNull
        private final RequestThrottler throttler;
        @NotNull
        private final UserAgentProvider userAgentProvider;

        public Config(@NotNull RequestThrottler throttler, @NotNull UserAgentProvider userAgentProvider) {
            Intrinsics.checkNotNullParameter((Object)throttler, (String)"throttler");
            Intrinsics.checkNotNullParameter((Object)userAgentProvider, (String)"userAgentProvider");
            this.throttler = throttler;
            this.userAgentProvider = userAgentProvider;
        }

        public /* synthetic */ Config(RequestThrottler requestThrottler, UserAgentProvider userAgentProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                requestThrottler = NoRequestThrottling.INSTANCE;
            }
            if ((n & 2) != 0) {
                userAgentProvider = new ResourceFileUserAgentProvider("default_user_agents.txt");
            }
            this(requestThrottler, userAgentProvider);
        }

        @NotNull
        public final RequestThrottler getThrottler() {
            return this.throttler;
        }

        @NotNull
        public final UserAgentProvider getUserAgentProvider() {
            return this.userAgentProvider;
        }

        public Config() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/arthurivanets/googleplayscraper/GooglePlayScraper$Companion;", "", "()V", "HTTP_CONNECT_TIMEOUT", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "HTTP_READ_TIMEOUT", "HTTP_WRITE_TIMEOUT", "google-play-scraper"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

