/*
 * Decompiled with CFR 0.152.
 */
package com.arthurivanets.googleplayscraper.parsers;

import com.arthurivanets.googleplayscraper.model.AppDetails;
import com.arthurivanets.googleplayscraper.modelfactories.ModelFactory;
import com.arthurivanets.googleplayscraper.parsers.ResultParser;
import com.arthurivanets.googleplayscraper.specs.AppDetailsSpec;
import com.arthurivanets.googleplayscraper.util.ResponseJsonExtractor;
import com.google.gson.JsonElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0002H\u0016R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/arthurivanets/googleplayscraper/parsers/AppDetailsResultParser;", "Lcom/arthurivanets/googleplayscraper/parsers/ResultParser;", "", "Lcom/arthurivanets/googleplayscraper/model/AppDetails;", "appDetailsSpec", "Lcom/arthurivanets/googleplayscraper/specs/AppDetailsSpec;", "responseJsonExtractor", "Lcom/arthurivanets/googleplayscraper/util/ResponseJsonExtractor;", "appDetailsModelFactory", "Lcom/arthurivanets/googleplayscraper/modelfactories/ModelFactory;", "Lcom/google/gson/JsonElement;", "(Lcom/arthurivanets/googleplayscraper/specs/AppDetailsSpec;Lcom/arthurivanets/googleplayscraper/util/ResponseJsonExtractor;Lcom/arthurivanets/googleplayscraper/modelfactories/ModelFactory;)V", "parse", "input", "google-play-scraper"})
public final class AppDetailsResultParser
implements ResultParser<String, AppDetails> {
    @NotNull
    private final AppDetailsSpec appDetailsSpec;
    @NotNull
    private final ResponseJsonExtractor responseJsonExtractor;
    @NotNull
    private final ModelFactory<AppDetailsSpec, JsonElement, AppDetails> appDetailsModelFactory;

    public AppDetailsResultParser(@NotNull AppDetailsSpec appDetailsSpec, @NotNull ResponseJsonExtractor responseJsonExtractor2, @NotNull ModelFactory<AppDetailsSpec, JsonElement, AppDetails> appDetailsModelFactory) {
        Intrinsics.checkNotNullParameter((Object)appDetailsSpec, (String)"appDetailsSpec");
        Intrinsics.checkNotNullParameter((Object)responseJsonExtractor2, (String)"responseJsonExtractor");
        Intrinsics.checkNotNullParameter(appDetailsModelFactory, (String)"appDetailsModelFactory");
        this.appDetailsSpec = appDetailsSpec;
        this.responseJsonExtractor = responseJsonExtractor2;
        this.appDetailsModelFactory = appDetailsModelFactory;
    }

    @Override
    @NotNull
    public AppDetails parse(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!(!StringsKt.isBlank((CharSequence)input))) {
            boolean bl = false;
            String string = "The Input MUST BE a non-blank String";
            throw new IllegalArgumentException(string.toString());
        }
        JsonElement result = this.responseJsonExtractor.extract(input);
        return this.appDetailsModelFactory.create(this.appDetailsSpec, result);
    }
}

