/*
 * Decompiled with CFR 0.152.
 */
package com.arthurivanets.googleplayscraper.parsers;

import com.arthurivanets.googleplayscraper.model.AppReview;
import com.arthurivanets.googleplayscraper.modelfactories.ModelFactory;
import com.arthurivanets.googleplayscraper.parsers.ResultParser;
import com.arthurivanets.googleplayscraper.specs.AppReviewSpec;
import com.arthurivanets.googleplayscraper.specs.AppReviewsResponseSpec;
import com.arthurivanets.googleplayscraper.util.PagedResult;
import com.arthurivanets.googleplayscraper.util.PathProcessor;
import com.arthurivanets.googleplayscraper.util.ResponseJsonExtractor;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00030\u0001BE\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u001c\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00032\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/arthurivanets/googleplayscraper/parsers/AppReviewsResultParser;", "Lcom/arthurivanets/googleplayscraper/parsers/ResultParser;", "", "Lcom/arthurivanets/googleplayscraper/util/PagedResult;", "", "Lcom/arthurivanets/googleplayscraper/model/AppReview;", "responseSpec", "Lcom/arthurivanets/googleplayscraper/specs/AppReviewsResponseSpec;", "appReviewSpec", "Lcom/arthurivanets/googleplayscraper/specs/AppReviewSpec;", "responseJsonExtractor", "Lcom/arthurivanets/googleplayscraper/util/ResponseJsonExtractor;", "pathProcessor", "Lcom/arthurivanets/googleplayscraper/util/PathProcessor;", "Lcom/google/gson/JsonElement;", "appReviewModelFactory", "Lcom/arthurivanets/googleplayscraper/modelfactories/ModelFactory;", "(Lcom/arthurivanets/googleplayscraper/specs/AppReviewsResponseSpec;Lcom/arthurivanets/googleplayscraper/specs/AppReviewSpec;Lcom/arthurivanets/googleplayscraper/util/ResponseJsonExtractor;Lcom/arthurivanets/googleplayscraper/util/PathProcessor;Lcom/arthurivanets/googleplayscraper/modelfactories/ModelFactory;)V", "extractToken", "contentJson", "parse", "input", "google-play-scraper"})
public final class AppReviewsResultParser
implements ResultParser<String, PagedResult<List<? extends AppReview>>> {
    @NotNull
    private final AppReviewsResponseSpec responseSpec;
    @NotNull
    private final AppReviewSpec appReviewSpec;
    @NotNull
    private final ResponseJsonExtractor responseJsonExtractor;
    @NotNull
    private final PathProcessor<JsonElement> pathProcessor;
    @NotNull
    private final ModelFactory<AppReviewSpec, JsonElement, AppReview> appReviewModelFactory;

    public AppReviewsResultParser(@NotNull AppReviewsResponseSpec responseSpec, @NotNull AppReviewSpec appReviewSpec, @NotNull ResponseJsonExtractor responseJsonExtractor2, @NotNull PathProcessor<JsonElement> pathProcessor2, @NotNull ModelFactory<AppReviewSpec, JsonElement, AppReview> appReviewModelFactory2) {
        Intrinsics.checkNotNullParameter((Object)responseSpec, (String)"responseSpec");
        Intrinsics.checkNotNullParameter((Object)appReviewSpec, (String)"appReviewSpec");
        Intrinsics.checkNotNullParameter((Object)responseJsonExtractor2, (String)"responseJsonExtractor");
        Intrinsics.checkNotNullParameter(pathProcessor2, (String)"pathProcessor");
        Intrinsics.checkNotNullParameter(appReviewModelFactory2, (String)"appReviewModelFactory");
        this.responseSpec = responseSpec;
        this.appReviewSpec = appReviewSpec;
        this.responseJsonExtractor = responseJsonExtractor2;
        this.pathProcessor = pathProcessor2;
        this.appReviewModelFactory = appReviewModelFactory2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PagedResult<List<AppReview>> parse(@NotNull String input) {
        List list;
        JsonArray rawAppReviews;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!(!StringsKt.isBlank((CharSequence)input))) {
            boolean $i$a$-require-AppReviewsResultParser$parse$22 = false;
            String $i$a$-require-AppReviewsResultParser$parse$22 = "The Input MUST BE a non-blank String";
            throw new IllegalArgumentException($i$a$-require-AppReviewsResultParser$parse$22.toString());
        }
        JsonElement contentJson = this.responseJsonExtractor.extract(input);
        String parsedToken = this.extractToken(contentJson);
        JsonArray jsonArray = rawAppReviews = (JsonArray)this.pathProcessor.extract(contentJson, this.responseSpec.getReviews());
        if (jsonArray == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)jsonArray;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void appReview;
                JsonElement jsonElement = (JsonElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)appReview, (String)"appReview");
                collection.add(this.appReviewModelFactory.create(this.appReviewSpec, (JsonElement)appReview));
            }
            list = (List)destination$iv$iv;
        }
        List list2 = list;
        List parsedAppReviews = list2 == null ? CollectionsKt.emptyList() : list2;
        return new PagedResult<List<AppReview>>(parsedAppReviews, parsedToken);
    }

    private final String extractToken(JsonElement contentJson) {
        String string;
        JsonElement jsonElement = (JsonElement)this.pathProcessor.extract(contentJson, this.responseSpec.getToken());
        if (jsonElement == null) {
            string = null;
        } else {
            JsonElement token = jsonElement;
            boolean bl = false;
            string = token.isJsonNull() ? null : token.getAsString();
        }
        return string;
    }
}

