/*
 * Decompiled with CFR 0.152.
 */
package com.arthurivanets.googleplayscraper.parsers;

import com.arthurivanets.googleplayscraper.model.App;
import com.arthurivanets.googleplayscraper.modelfactories.ModelFactory;
import com.arthurivanets.googleplayscraper.parsers.ResultParser;
import com.arthurivanets.googleplayscraper.specs.AppSearchResponseSpec;
import com.arthurivanets.googleplayscraper.specs.AppSpec;
import com.arthurivanets.googleplayscraper.util.PagedResult;
import com.arthurivanets.googleplayscraper.util.Path;
import com.arthurivanets.googleplayscraper.util.PathProcessor;
import com.arthurivanets.googleplayscraper.util.ResponseJsonExtractor;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00030\u0001BM\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00050\u0011\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u001c\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00032\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u001c\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00032\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u001c\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00032\u0006\u0010\u0014\u001a\u00020\u000fH\u0002R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00050\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/arthurivanets/googleplayscraper/parsers/AppSearchResultParser;", "Lcom/arthurivanets/googleplayscraper/parsers/ResultParser;", "", "Lcom/arthurivanets/googleplayscraper/util/PagedResult;", "", "Lcom/arthurivanets/googleplayscraper/model/App;", "responseSpec", "Lcom/arthurivanets/googleplayscraper/specs/AppSearchResponseSpec;", "featuredAppSpec", "Lcom/arthurivanets/googleplayscraper/specs/AppSpec;", "appSpec", "responseJsonExtractor", "Lcom/arthurivanets/googleplayscraper/util/ResponseJsonExtractor;", "pathProcessor", "Lcom/arthurivanets/googleplayscraper/util/PathProcessor;", "Lcom/google/gson/JsonElement;", "appModelFactory", "Lcom/arthurivanets/googleplayscraper/modelfactories/ModelFactory;", "(Lcom/arthurivanets/googleplayscraper/specs/AppSearchResponseSpec;Lcom/arthurivanets/googleplayscraper/specs/AppSpec;Lcom/arthurivanets/googleplayscraper/specs/AppSpec;Lcom/arthurivanets/googleplayscraper/util/ResponseJsonExtractor;Lcom/arthurivanets/googleplayscraper/util/PathProcessor;Lcom/arthurivanets/googleplayscraper/modelfactories/ModelFactory;)V", "extractApps", "contentJson", "spec", "Lcom/arthurivanets/googleplayscraper/util/Path;", "extractToken", "hasFeaturedApp", "", "hasNoResults", "parse", "input", "parseResult", "parseResultWithFeaturedApp", "google-play-scraper"})
public final class AppSearchResultParser
implements ResultParser<String, PagedResult<List<? extends App>>> {
    @NotNull
    private final AppSearchResponseSpec responseSpec;
    @NotNull
    private final AppSpec featuredAppSpec;
    @NotNull
    private final AppSpec appSpec;
    @NotNull
    private final ResponseJsonExtractor responseJsonExtractor;
    @NotNull
    private final PathProcessor<JsonElement> pathProcessor;
    @NotNull
    private final ModelFactory<AppSpec, JsonElement, App> appModelFactory;

    public AppSearchResultParser(@NotNull AppSearchResponseSpec responseSpec, @NotNull AppSpec featuredAppSpec, @NotNull AppSpec appSpec, @NotNull ResponseJsonExtractor responseJsonExtractor2, @NotNull PathProcessor<JsonElement> pathProcessor2, @NotNull ModelFactory<AppSpec, JsonElement, App> appModelFactory2) {
        Intrinsics.checkNotNullParameter((Object)responseSpec, (String)"responseSpec");
        Intrinsics.checkNotNullParameter((Object)featuredAppSpec, (String)"featuredAppSpec");
        Intrinsics.checkNotNullParameter((Object)appSpec, (String)"appSpec");
        Intrinsics.checkNotNullParameter((Object)responseJsonExtractor2, (String)"responseJsonExtractor");
        Intrinsics.checkNotNullParameter(pathProcessor2, (String)"pathProcessor");
        Intrinsics.checkNotNullParameter(appModelFactory2, (String)"appModelFactory");
        this.responseSpec = responseSpec;
        this.featuredAppSpec = featuredAppSpec;
        this.appSpec = appSpec;
        this.responseJsonExtractor = responseJsonExtractor2;
        this.pathProcessor = pathProcessor2;
        this.appModelFactory = appModelFactory2;
    }

    @Override
    @NotNull
    public PagedResult<List<App>> parse(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!(!StringsKt.isBlank((CharSequence)input))) {
            boolean bl = false;
            String string = "The Input MUST BE a non-blank String";
            throw new IllegalArgumentException(string.toString());
        }
        JsonElement contentJson = this.responseJsonExtractor.extract(input);
        return this.hasNoResults(contentJson) ? new PagedResult<List<App>>(CollectionsKt.emptyList(), null) : (this.hasFeaturedApp(contentJson) ? this.parseResultWithFeaturedApp(contentJson) : this.parseResult(contentJson));
    }

    private final PagedResult<List<App>> parseResultWithFeaturedApp(JsonElement contentJson) {
        List list;
        JsonElement jsonElement = (JsonElement)this.pathProcessor.extract(contentJson, this.responseSpec.getFeaturedApp());
        if (jsonElement == null) {
            list = null;
        } else {
            JsonElement rawApp = jsonElement;
            boolean bl = false;
            App app = this.appModelFactory.create(this.featuredAppSpec, rawApp);
            if (app == null) {
                list = null;
            } else {
                App p0 = app;
                boolean bl2 = false;
                list = CollectionsKt.listOf((Object)p0);
            }
        }
        List list2 = list;
        List featuredApps = list2 == null ? CollectionsKt.emptyList() : list2;
        return new PagedResult<List<App>>(CollectionsKt.plus((Collection)featuredApps, (Iterable)this.extractApps(contentJson, this.responseSpec.getMoreApps())), null);
    }

    private final PagedResult<List<App>> parseResult(JsonElement contentJson) {
        return new PagedResult<List<App>>(this.extractApps(contentJson, this.responseSpec.getApps()), this.extractToken(contentJson));
    }

    private final boolean hasNoResults(JsonElement contentJson) {
        JsonElement indicator;
        JsonElement jsonElement = indicator = (JsonElement)this.pathProcessor.extract(contentJson, this.responseSpec.getNoResultsSectionIndicator());
        return jsonElement == null ? false : jsonElement.isJsonPrimitive();
    }

    private final boolean hasFeaturedApp(JsonElement contentJson) {
        JsonElement indicator;
        JsonElement jsonElement = indicator = (JsonElement)this.pathProcessor.extract(contentJson, this.responseSpec.getFeaturedAppsSectionIndicator());
        return jsonElement == null ? false : jsonElement.isJsonPrimitive();
    }

    /*
     * WARNING - void declaration
     */
    private final List<App> extractApps(JsonElement contentJson, Path spec) {
        List list;
        JsonArray rawApps;
        JsonArray jsonArray = rawApps = (JsonArray)this.pathProcessor.extract(contentJson, spec);
        if (jsonArray == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)jsonArray;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void app;
                JsonElement jsonElement = (JsonElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)app, (String)"app");
                collection.add(this.appModelFactory.create(this.appSpec, (JsonElement)app));
            }
            list = (List)destination$iv$iv;
        }
        List list2 = list;
        if (list == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final String extractToken(JsonElement contentJson) {
        String string;
        JsonElement jsonElement = (JsonElement)this.pathProcessor.extract(contentJson, this.responseSpec.getMoreResultsToken());
        if (jsonElement == null) {
            string = null;
        } else {
            JsonElement token = jsonElement;
            boolean bl = false;
            string = token.isJsonNull() ? null : token.getAsString();
        }
        return string;
    }
}

