/*
 * Decompiled with CFR 0.152.
 */
package com.arthurivanets.googleplayscraper.parsers;

import com.arthurivanets.googleplayscraper.parsers.ResultParser;
import com.arthurivanets.googleplayscraper.util.Path;
import com.arthurivanets.googleplayscraper.util.PathProcessor;
import com.arthurivanets.googleplayscraper.util.ResponseJsonExtractor;
import com.arthurivanets.googleplayscraper.util.ScraperError;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/arthurivanets/googleplayscraper/parsers/AppsClusterUrlResultParser;", "Lcom/arthurivanets/googleplayscraper/parsers/ResultParser;", "", "clusterSpec", "Lcom/arthurivanets/googleplayscraper/util/Path;", "responseJsonExtractor", "Lcom/arthurivanets/googleplayscraper/util/ResponseJsonExtractor;", "pathProcessor", "Lcom/arthurivanets/googleplayscraper/util/PathProcessor;", "Lcom/google/gson/JsonElement;", "(Lcom/arthurivanets/googleplayscraper/util/Path;Lcom/arthurivanets/googleplayscraper/util/ResponseJsonExtractor;Lcom/arthurivanets/googleplayscraper/util/PathProcessor;)V", "parse", "input", "google-play-scraper"})
public final class AppsClusterUrlResultParser
implements ResultParser<String, String> {
    @NotNull
    private final Path clusterSpec;
    @NotNull
    private final ResponseJsonExtractor responseJsonExtractor;
    @NotNull
    private final PathProcessor<JsonElement> pathProcessor;

    public AppsClusterUrlResultParser(@NotNull Path clusterSpec, @NotNull ResponseJsonExtractor responseJsonExtractor2, @NotNull PathProcessor<JsonElement> pathProcessor2) {
        Intrinsics.checkNotNullParameter((Object)clusterSpec, (String)"clusterSpec");
        Intrinsics.checkNotNullParameter((Object)responseJsonExtractor2, (String)"responseJsonExtractor");
        Intrinsics.checkNotNullParameter(pathProcessor2, (String)"pathProcessor");
        this.clusterSpec = clusterSpec;
        this.responseJsonExtractor = responseJsonExtractor2;
        this.pathProcessor = pathProcessor2;
    }

    @Override
    @NotNull
    public String parse(@NotNull String input) {
        String clusterUrl;
        String string;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!(!StringsKt.isBlank((CharSequence)input))) {
            boolean $i$a$-require-AppsClusterUrlResultParser$parse$22 = false;
            String $i$a$-require-AppsClusterUrlResultParser$parse$22 = "The Input MUST BE a non-blank String";
            throw new IllegalArgumentException($i$a$-require-AppsClusterUrlResultParser$parse$22.toString());
        }
        JsonElement result = this.responseJsonExtractor.extract(input);
        JsonElement jsonElement = (JsonElement)this.pathProcessor.extract(result, this.clusterSpec);
        if (jsonElement == null) {
            string = null;
        } else {
            JsonElement $this$inferType$iv = jsonElement;
            boolean $i$f$inferType = false;
            KClass kClass = Reflection.getOrCreateKotlinClass(String.class);
            if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                string = (String)((Object)Boolean.valueOf($this$inferType$iv.getAsBoolean()));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                string = $this$inferType$iv.getAsString();
                if (string == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
                Number number = $this$inferType$iv.getAsNumber();
                if (number == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                string = (String)((Object)number);
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                string = (String)((Object)Double.valueOf($this$inferType$iv.getAsDouble()));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                string = (String)((Object)Float.valueOf($this$inferType$iv.getAsFloat()));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                string = (String)((Object)Long.valueOf($this$inferType$iv.getAsLong()));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                string = (String)((Object)Integer.valueOf($this$inferType$iv.getAsInt()));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
                string = (String)((Object)Byte.valueOf($this$inferType$iv.getAsByte()));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
                string = (String)((Object)Short.valueOf($this$inferType$iv.getAsShort()));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
                BigDecimal bigDecimal = $this$inferType$iv.getAsBigDecimal();
                if (bigDecimal == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                string = (String)((Object)bigDecimal);
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(BigInteger.class))) {
                BigInteger bigInteger = $this$inferType$iv.getAsBigInteger();
                if (bigInteger == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                string = (String)((Object)bigInteger);
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(JsonNull.class))) {
                JsonNull jsonNull = $this$inferType$iv.getAsJsonNull();
                if (jsonNull == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                string = (String)jsonNull;
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(JsonPrimitive.class))) {
                JsonPrimitive jsonPrimitive = $this$inferType$iv.getAsJsonPrimitive();
                if (jsonPrimitive == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                string = (String)jsonPrimitive;
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(JsonArray.class))) {
                JsonArray jsonArray = $this$inferType$iv.getAsJsonArray();
                if (jsonArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                string = (String)jsonArray;
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(JsonObject.class))) {
                JsonObject jsonObject = $this$inferType$iv.getAsJsonObject();
                if (jsonObject == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                string = (String)jsonObject;
            } else {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unsupported Type = ", (Object)Reflection.getOrCreateKotlinClass(String.class).getQualifiedName()));
            }
        }
        String string2 = clusterUrl = string;
        if (string2 == null) {
            throw new ScraperError.ResponseParsingError("No Valid Cluster URL Found for the specified path.", null, 2, null);
        }
        return string2;
    }
}

