/*
 * Decompiled with CFR 0.152.
 */
package com.arthurivanets.googleplayscraper.parsers;

import com.arthurivanets.googleplayscraper.model.Permission;
import com.arthurivanets.googleplayscraper.parsers.ResultParser;
import com.arthurivanets.googleplayscraper.specs.PermissionsCategorySpec;
import com.arthurivanets.googleplayscraper.specs.PermissionsResponseSpec;
import com.arthurivanets.googleplayscraper.specs.PermissionsSectionSpec;
import com.arthurivanets.googleplayscraper.util.Path;
import com.arthurivanets.googleplayscraper.util.PathProcessor;
import com.arthurivanets.googleplayscraper.util.ResponseJsonExtractor;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001:\u0001\u0013B#\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0012H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/arthurivanets/googleplayscraper/parsers/PermissionsResultParser;", "Lcom/arthurivanets/googleplayscraper/parsers/ResultParser;", "", "", "Lcom/arthurivanets/googleplayscraper/model/Permission;", "pathProcessor", "Lcom/arthurivanets/googleplayscraper/util/PathProcessor;", "Lcom/google/gson/JsonElement;", "responseJsonExtractor", "Lcom/arthurivanets/googleplayscraper/util/ResponseJsonExtractor;", "responseSpec", "Lcom/arthurivanets/googleplayscraper/specs/PermissionsResponseSpec;", "(Lcom/arthurivanets/googleplayscraper/util/PathProcessor;Lcom/arthurivanets/googleplayscraper/util/ResponseJsonExtractor;Lcom/arthurivanets/googleplayscraper/specs/PermissionsResponseSpec;)V", "parse", "input", "extractPermissions", "spec", "Lcom/arthurivanets/googleplayscraper/specs/PermissionsCategorySpec;", "Lcom/arthurivanets/googleplayscraper/specs/PermissionsSectionSpec;", "Companion", "google-play-scraper"})
public final class PermissionsResultParser
implements ResultParser<String, List<? extends Permission>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PathProcessor<JsonElement> pathProcessor;
    @NotNull
    private final ResponseJsonExtractor responseJsonExtractor;
    @NotNull
    private final PermissionsResponseSpec responseSpec;
    @NotNull
    private static final String DEFAULT_CATEGORY_TYPE = "Other";

    public PermissionsResultParser(@NotNull PathProcessor<JsonElement> pathProcessor2, @NotNull ResponseJsonExtractor responseJsonExtractor2, @NotNull PermissionsResponseSpec responseSpec) {
        Intrinsics.checkNotNullParameter(pathProcessor2, (String)"pathProcessor");
        Intrinsics.checkNotNullParameter((Object)responseJsonExtractor2, (String)"responseJsonExtractor");
        Intrinsics.checkNotNullParameter((Object)responseSpec, (String)"responseSpec");
        this.pathProcessor = pathProcessor2;
        this.responseJsonExtractor = responseJsonExtractor2;
        this.responseSpec = responseSpec;
    }

    @Override
    @NotNull
    public List<Permission> parse(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!(!StringsKt.isBlank((CharSequence)input))) {
            boolean $i$a$-require-PermissionsResultParser$parse$22 = false;
            String $i$a$-require-PermissionsResultParser$parse$22 = "The Input MUST BE a non-blank String";
            throw new IllegalArgumentException($i$a$-require-PermissionsResultParser$parse$22.toString());
        }
        JsonElement contentJson = this.responseJsonExtractor.extract(input);
        List<Permission> categorizedPermissions = this.extractPermissions(contentJson, this.responseSpec.getCategorized());
        List<Permission> otherPermissions = this.extractPermissions(contentJson, this.responseSpec.getOther());
        List<Permission> leftoverPermissions = this.extractPermissions(contentJson, this.responseSpec.getLeftover());
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)categorizedPermissions, (Iterable)otherPermissions), (Iterable)leftoverPermissions);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Permission> extractPermissions(JsonElement $this$extractPermissions, PermissionsSectionSpec spec) {
        void $this$mapTo$iv$iv;
        JsonArray jsonArray = (JsonArray)this.pathProcessor.extract($this$extractPermissions, spec.getSection());
        if (jsonArray == null) {
            return CollectionsKt.emptyList();
        }
        JsonArray rawPermissionsSection = jsonArray;
        Iterable $this$map$iv = (Iterable)rawPermissionsSection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void rawCategory;
            JsonElement jsonElement = (JsonElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)rawCategory, (String)"rawCategory");
            collection.add(this.extractPermissions((JsonElement)rawCategory, spec.getCategory()));
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Permission> extractPermissions(JsonElement $this$extractPermissions, PermissionsCategorySpec spec) {
        void $this$mapTo$iv$iv;
        JsonArray jsonArray;
        String type;
        KClass kClass;
        Object typeSpec;
        String string;
        Path path = spec.getCategoryType();
        if (path == null) {
            string = DEFAULT_CATEGORY_TYPE;
        } else {
            String string2;
            typeSpec = path;
            boolean bl = false;
            JsonElement jsonElement = (JsonElement)this.pathProcessor.extract($this$extractPermissions, (Path)typeSpec);
            if (jsonElement == null) {
                string2 = null;
            } else {
                JsonElement $this$inferType$iv = jsonElement;
                boolean $i$f$inferType = false;
                kClass = Reflection.getOrCreateKotlinClass(String.class);
                if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    string2 = (String)((Object)Boolean.valueOf($this$inferType$iv.getAsBoolean()));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    string2 = $this$inferType$iv.getAsString();
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
                    Number number = $this$inferType$iv.getAsNumber();
                    if (number == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string2 = (String)((Object)number);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                    string2 = (String)((Object)Double.valueOf($this$inferType$iv.getAsDouble()));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    string2 = (String)((Object)Float.valueOf($this$inferType$iv.getAsFloat()));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    string2 = (String)((Object)Long.valueOf($this$inferType$iv.getAsLong()));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    string2 = (String)((Object)Integer.valueOf($this$inferType$iv.getAsInt()));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
                    string2 = (String)((Object)Byte.valueOf($this$inferType$iv.getAsByte()));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
                    string2 = (String)((Object)Short.valueOf($this$inferType$iv.getAsShort()));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
                    BigDecimal bigDecimal = $this$inferType$iv.getAsBigDecimal();
                    if (bigDecimal == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string2 = (String)((Object)bigDecimal);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(BigInteger.class))) {
                    BigInteger bigInteger = $this$inferType$iv.getAsBigInteger();
                    if (bigInteger == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string2 = (String)((Object)bigInteger);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(JsonNull.class))) {
                    JsonNull jsonNull = $this$inferType$iv.getAsJsonNull();
                    if (jsonNull == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string2 = (String)jsonNull;
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(JsonPrimitive.class))) {
                    JsonPrimitive jsonPrimitive = $this$inferType$iv.getAsJsonPrimitive();
                    if (jsonPrimitive == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string2 = (String)jsonPrimitive;
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(JsonArray.class))) {
                    JsonArray jsonArray2 = $this$inferType$iv.getAsJsonArray();
                    if (jsonArray2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string2 = (String)jsonArray2;
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(JsonObject.class))) {
                    JsonObject jsonObject = $this$inferType$iv.getAsJsonObject();
                    if (jsonObject == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string2 = (String)jsonObject;
                } else {
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unsupported Type = ", (Object)Reflection.getOrCreateKotlinClass(String.class).getQualifiedName()));
                }
            }
            String string3 = string2;
            string = type = string3 == null ? DEFAULT_CATEGORY_TYPE : string3;
        }
        if ((jsonArray = (JsonArray)this.pathProcessor.extract($this$extractPermissions, spec.getPermissions())) == null) {
            jsonArray = new JsonArray();
        }
        JsonArray rawPermissions = jsonArray;
        Iterable $this$map$iv = (Iterable)rawPermissions;
        boolean $i$f$map = false;
        typeSpec = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string4;
            void rawPermission;
            kClass = (JsonElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string5 = type;
            Intrinsics.checkNotNullExpressionValue((Object)rawPermission, (String)"rawPermission");
            JsonElement jsonElement = (JsonElement)this.pathProcessor.extract((JsonElement)rawPermission, spec.getPermissionDescription());
            if (jsonElement == null) {
                string4 = null;
            } else {
                void $this$inferType$iv;
                JsonElement jsonElement2 = jsonElement;
                boolean $i$f$inferType = false;
                KClass kClass2 = Reflection.getOrCreateKotlinClass(String.class);
                if (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    string4 = (String)((Object)Boolean.valueOf($this$inferType$iv.getAsBoolean()));
                } else if (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    string4 = $this$inferType$iv.getAsString();
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                } else if (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
                    Number number = $this$inferType$iv.getAsNumber();
                    if (number == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string4 = (String)((Object)number);
                } else if (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                    string4 = (String)((Object)Double.valueOf($this$inferType$iv.getAsDouble()));
                } else if (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    string4 = (String)((Object)Float.valueOf($this$inferType$iv.getAsFloat()));
                } else if (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    string4 = (String)((Object)Long.valueOf($this$inferType$iv.getAsLong()));
                } else if (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    string4 = (String)((Object)Integer.valueOf($this$inferType$iv.getAsInt()));
                } else if (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
                    string4 = (String)((Object)Byte.valueOf($this$inferType$iv.getAsByte()));
                } else if (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
                    string4 = (String)((Object)Short.valueOf($this$inferType$iv.getAsShort()));
                } else if (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
                    BigDecimal bigDecimal = $this$inferType$iv.getAsBigDecimal();
                    if (bigDecimal == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string4 = (String)((Object)bigDecimal);
                } else if (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(BigInteger.class))) {
                    BigInteger bigInteger = $this$inferType$iv.getAsBigInteger();
                    if (bigInteger == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string4 = (String)((Object)bigInteger);
                } else if (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(JsonNull.class))) {
                    JsonNull jsonNull = $this$inferType$iv.getAsJsonNull();
                    if (jsonNull == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string4 = (String)jsonNull;
                } else if (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(JsonPrimitive.class))) {
                    JsonPrimitive jsonPrimitive = $this$inferType$iv.getAsJsonPrimitive();
                    if (jsonPrimitive == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string4 = (String)jsonPrimitive;
                } else if (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(JsonArray.class))) {
                    JsonArray jsonArray3 = $this$inferType$iv.getAsJsonArray();
                    if (jsonArray3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string4 = (String)jsonArray3;
                } else if (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(JsonObject.class))) {
                    JsonObject jsonObject = $this$inferType$iv.getAsJsonObject();
                    if (jsonObject == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string4 = (String)jsonObject;
                } else {
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unsupported Type = ", (Object)Reflection.getOrCreateKotlinClass(String.class).getQualifiedName()));
                }
            }
            if (string4 == null) {
                String string6 = string5;
                boolean bl2 = false;
                String string7 = string6;
                String string8 = "Permission description extraction failed. No valid description found. (Category type = " + type + ')';
                throw new IllegalArgumentException(string8.toString());
            }
            String string9 = string4;
            String string10 = string5;
            collection.add(new Permission(string10, string9));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/arthurivanets/googleplayscraper/parsers/PermissionsResultParser$Companion;", "", "()V", "DEFAULT_CATEGORY_TYPE", "", "google-play-scraper"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

