/*
 * Decompiled with CFR 0.152.
 */
package com.arthurivanets.googleplayscraper.requests;

import com.arthurivanets.googleplayscraper.model.AppReview;
import com.arthurivanets.googleplayscraper.parsers.ResultParser;
import com.arthurivanets.googleplayscraper.requests.GetAppReviewsParams;
import com.arthurivanets.googleplayscraper.requests.Request;
import com.arthurivanets.googleplayscraper.requests.Response;
import com.arthurivanets.googleplayscraper.requests.ResponseExtensionsKt;
import com.arthurivanets.googleplayscraper.util.PagedResult;
import com.arthurivanets.googleplayscraper.util.RequestUtilsKt;
import com.arthurivanets.googleplayscraper.util.ScraperError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B=\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u001e\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\u0011\u001a\u00020\u0007H\u0002J\u001a\u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002J\f\u0010\u0017\u001a\u00020\u0003*\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/arthurivanets/googleplayscraper/requests/GetAppReviewsRequest;", "Lcom/arthurivanets/googleplayscraper/requests/Request;", "", "Lcom/arthurivanets/googleplayscraper/model/AppReview;", "params", "Lcom/arthurivanets/googleplayscraper/requests/GetAppReviewsParams;", "baseUrl", "", "httpClient", "Lokhttp3/OkHttpClient;", "requestResultParser", "Lcom/arthurivanets/googleplayscraper/parsers/ResultParser;", "Lcom/arthurivanets/googleplayscraper/util/PagedResult;", "(Lcom/arthurivanets/googleplayscraper/requests/GetAppReviewsParams;Ljava/lang/String;Lokhttp3/OkHttpClient;Lcom/arthurivanets/googleplayscraper/parsers/ResultParser;)V", "createRequestBody", "Lokhttp3/RequestBody;", "token", "createRequestUrl", "execute", "Lcom/arthurivanets/googleplayscraper/requests/Response;", "Lcom/arthurivanets/googleplayscraper/util/ScraperError;", "executeRequest", "Lokhttp3/Response;", "appendDetails", "google-play-scraper"})
public final class GetAppReviewsRequest
implements Request<List<? extends AppReview>> {
    @NotNull
    private final GetAppReviewsParams params;
    @NotNull
    private final String baseUrl;
    @NotNull
    private final OkHttpClient httpClient;
    @NotNull
    private final ResultParser<String, PagedResult<List<AppReview>>> requestResultParser;

    public GetAppReviewsRequest(@NotNull GetAppReviewsParams params, @NotNull String baseUrl, @NotNull OkHttpClient httpClient2, @NotNull ResultParser<String, PagedResult<List<AppReview>>> requestResultParser) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)httpClient2, (String)"httpClient");
        Intrinsics.checkNotNullParameter(requestResultParser, (String)"requestResultParser");
        this.params = params;
        this.baseUrl = baseUrl;
        this.httpClient = httpClient2;
        this.requestResultParser = requestResultParser;
    }

    @Override
    @NotNull
    public Response<List<AppReview>, ScraperError> execute() {
        return ResponseExtensionsKt.response((Function0)new Function0<List<? extends AppReview>>(this){
            final /* synthetic */ GetAppReviewsRequest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<AppReview> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = RequestUtilsKt.fetchContinuously(GetAppReviewsRequest.access$getParams$p(this.this$0).getLimit(), (Function0<okhttp3.Response>)((Function0)new Function0<okhttp3.Response>(this.this$0){
                    final /* synthetic */ GetAppReviewsRequest this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final okhttp3.Response invoke() {
                        return GetAppReviewsRequest.access$executeRequest(this.this$0, null);
                    }
                }), GetAppReviewsRequest.access$getRequestResultParser$p(this.this$0), (Function1<? super String, okhttp3.Response>)((Function1)new Function1<String, okhttp3.Response>((Object)this.this$0){

                    @NotNull
                    public final okhttp3.Response invoke(@Nullable String p0) {
                        return GetAppReviewsRequest.access$executeRequest((GetAppReviewsRequest)this.receiver, p0);
                    }
                }), GetAppReviewsRequest.access$getRequestResultParser$p(this.this$0));
                GetAppReviewsRequest getAppReviewsRequest = this.this$0;
                boolean $i$f$map = false;
                void var4_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void review;
                    AppReview appReview = (AppReview)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(GetAppReviewsRequest.access$appendDetails(getAppReviewsRequest, (AppReview)review));
                }
                return (List)destination$iv$iv;
            }
        });
    }

    private final okhttp3.Response executeRequest(String token) {
        okhttp3.Request request = new Request.Builder().url(this.createRequestUrl()).post(this.createRequestBody(token)).build();
        OkHttpClient okHttpClient = this.httpClient;
        okhttp3.Request p0 = request;
        boolean bl = false;
        return okHttpClient.newCall(p0).execute();
    }

    private final String createRequestUrl() {
        StringBuilder stringBuilder;
        StringBuilder $this$createRequestUrl_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createRequestUrl_u24lambda_u2d0.append(this.baseUrl).append("/_/PlayStoreUi/data/batchexecute");
        $this$createRequestUrl_u24lambda_u2d0.append("?rpcids=qnKhOb");
        $this$createRequestUrl_u24lambda_u2d0.append("&f.sid=-697906427155521722");
        $this$createRequestUrl_u24lambda_u2d0.append("&bl=boq_playuiserver_20190903.08_p0");
        $this$createRequestUrl_u24lambda_u2d0.append("&hl=").append(this.params.getLanguage());
        $this$createRequestUrl_u24lambda_u2d0.append("&gl=").append(this.params.getCountry());
        $this$createRequestUrl_u24lambda_u2d0.append("&authuser");
        $this$createRequestUrl_u24lambda_u2d0.append("&soc-app=121");
        $this$createRequestUrl_u24lambda_u2d0.append("&soc-platform=1");
        $this$createRequestUrl_u24lambda_u2d0.append("&soc-device=1");
        $this$createRequestUrl_u24lambda_u2d0.append("&_reqid=1065213");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final RequestBody createRequestBody(String token) {
        int numberOfReviewsPerRequest = 150;
        int sortingOrder = this.params.getSortingOrder().getValue();
        String appId = this.params.getAppId();
        String body = token != null ? "f.req=%5B%5B%5B%22UsvDTd%22%2C%22%5Bnull%2Cnull%2C%5B2%2C" + sortingOrder + "%2C%5B" + numberOfReviewsPerRequest + "%2Cnull%2C%5C%22" + token + "%5C%22%5D%2Cnull%2C%5B%5D%5D%2C%5B%5C%22" + appId + "%5C%22%2C7%5D%5D%22%2Cnull%2C%22generic%22%5D%5D%5D" : "f.req=%5B%5B%5B%22UsvDTd%22%2C%22%5Bnull%2Cnull%2C%5B2%2C" + sortingOrder + "%2C%5B" + numberOfReviewsPerRequest + "%2Cnull%2Cnull%5D%2Cnull%2C%5B%5D%5D%2C%5B%5C%22" + appId + "%5C%22%2C7%5D%5D%22%2Cnull%2C%22generic%22%5D%5D%5D";
        String mediaType = "application/x-www-form-urlencoded;charset=UTF-8";
        return RequestBody.Companion.create(body, MediaType.Companion.get(mediaType));
    }

    private final AppReview appendDetails(AppReview $this$appendDetails) {
        String string = this.params.getAppId();
        String string2 = this.baseUrl + "/store/apps/details?id=" + this.params.getAppId() + "&reviewId=" + $this$appendDetails.getId();
        return AppReview.copy$default($this$appendDetails, null, string2, null, null, null, 0, null, null, null, null, null, null, string, 0, null, 28669, null);
    }

    public static final /* synthetic */ GetAppReviewsParams access$getParams$p(GetAppReviewsRequest $this) {
        return $this.params;
    }

    public static final /* synthetic */ okhttp3.Response access$executeRequest(GetAppReviewsRequest $this, String token) {
        return $this.executeRequest(token);
    }

    public static final /* synthetic */ ResultParser access$getRequestResultParser$p(GetAppReviewsRequest $this) {
        return $this.requestResultParser;
    }

    public static final /* synthetic */ AppReview access$appendDetails(GetAppReviewsRequest $this, AppReview $receiver) {
        return $this.appendDetails($receiver);
    }
}

