/*
 * Decompiled with CFR 0.152.
 */
package com.arthurivanets.googleplayscraper.requests;

import com.arthurivanets.googleplayscraper.model.App;
import com.arthurivanets.googleplayscraper.parsers.ResultParser;
import com.arthurivanets.googleplayscraper.requests.AppsLoadingRequestFactory;
import com.arthurivanets.googleplayscraper.requests.GetSimilarAppsParams;
import com.arthurivanets.googleplayscraper.requests.Request;
import com.arthurivanets.googleplayscraper.requests.Response;
import com.arthurivanets.googleplayscraper.requests.ResponseExtensionsKt;
import com.arthurivanets.googleplayscraper.util.OkHttpExtensionsKt;
import com.arthurivanets.googleplayscraper.util.PagedResult;
import com.arthurivanets.googleplayscraper.util.RequestUtilsKt;
import com.arthurivanets.googleplayscraper.util.ScraperError;
import com.arthurivanets.googleplayscraper.util.ScraperErrorKt;
import com.arthurivanets.googleplayscraper.util.UriComponent;
import com.arthurivanets.googleplayscraper.util.UriUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001By\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\r\u0012\u001e\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u000f0\r\u0012\u001e\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u000f0\r\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0007H\u0002J\u001a\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\b\u0010\u001a\u001a\u00020\u0017H\u0002J\b\u0010\u001b\u001a\u00020\u0007H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/arthurivanets/googleplayscraper/requests/GetSimilarAppsRequest;", "Lcom/arthurivanets/googleplayscraper/requests/Request;", "", "Lcom/arthurivanets/googleplayscraper/model/App;", "params", "Lcom/arthurivanets/googleplayscraper/requests/GetSimilarAppsParams;", "baseUrl", "", "httpClient", "Lokhttp3/OkHttpClient;", "appsLoadingRequestFactory", "Lcom/arthurivanets/googleplayscraper/requests/AppsLoadingRequestFactory;", "clusterUrlResultParser", "Lcom/arthurivanets/googleplayscraper/parsers/ResultParser;", "initialAppsResultParser", "Lcom/arthurivanets/googleplayscraper/util/PagedResult;", "appsResultParser", "(Lcom/arthurivanets/googleplayscraper/requests/GetSimilarAppsParams;Ljava/lang/String;Lokhttp3/OkHttpClient;Lcom/arthurivanets/googleplayscraper/requests/AppsLoadingRequestFactory;Lcom/arthurivanets/googleplayscraper/parsers/ResultParser;Lcom/arthurivanets/googleplayscraper/parsers/ResultParser;Lcom/arthurivanets/googleplayscraper/parsers/ResultParser;)V", "createClusterRequestUrl", "execute", "Lcom/arthurivanets/googleplayscraper/requests/Response;", "Lcom/arthurivanets/googleplayscraper/util/ScraperError;", "executeAppsRequest", "Lokhttp3/Response;", "token", "executeClusterUrlRequest", "executeInitialAppsRequest", "getClusterUrl", "google-play-scraper"})
public final class GetSimilarAppsRequest
implements Request<List<? extends App>> {
    @NotNull
    private final GetSimilarAppsParams params;
    @NotNull
    private final String baseUrl;
    @NotNull
    private final OkHttpClient httpClient;
    @NotNull
    private final AppsLoadingRequestFactory appsLoadingRequestFactory;
    @NotNull
    private final ResultParser<String, String> clusterUrlResultParser;
    @NotNull
    private final ResultParser<String, PagedResult<List<App>>> initialAppsResultParser;
    @NotNull
    private final ResultParser<String, PagedResult<List<App>>> appsResultParser;

    public GetSimilarAppsRequest(@NotNull GetSimilarAppsParams params, @NotNull String baseUrl, @NotNull OkHttpClient httpClient2, @NotNull AppsLoadingRequestFactory appsLoadingRequestFactory2, @NotNull ResultParser<String, String> clusterUrlResultParser, @NotNull ResultParser<String, PagedResult<List<App>>> initialAppsResultParser, @NotNull ResultParser<String, PagedResult<List<App>>> appsResultParser2) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)httpClient2, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)appsLoadingRequestFactory2, (String)"appsLoadingRequestFactory");
        Intrinsics.checkNotNullParameter(clusterUrlResultParser, (String)"clusterUrlResultParser");
        Intrinsics.checkNotNullParameter(initialAppsResultParser, (String)"initialAppsResultParser");
        Intrinsics.checkNotNullParameter(appsResultParser2, (String)"appsResultParser");
        this.params = params;
        this.baseUrl = baseUrl;
        this.httpClient = httpClient2;
        this.appsLoadingRequestFactory = appsLoadingRequestFactory2;
        this.clusterUrlResultParser = clusterUrlResultParser;
        this.initialAppsResultParser = initialAppsResultParser;
        this.appsResultParser = appsResultParser2;
    }

    @Override
    @NotNull
    public Response<List<App>, ScraperError> execute() {
        return ResponseExtensionsKt.response((Function0)new Function0<List<? extends App>>(this){
            final /* synthetic */ GetSimilarAppsRequest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<App> invoke() {
                return RequestUtilsKt.fetchContinuously(GetSimilarAppsRequest.access$getParams$p(this.this$0).getLimit(), (Function0<okhttp3.Response>)((Function0)new Function0<okhttp3.Response>((Object)this.this$0){

                    @NotNull
                    public final okhttp3.Response invoke() {
                        return GetSimilarAppsRequest.access$executeInitialAppsRequest((GetSimilarAppsRequest)this.receiver);
                    }
                }), GetSimilarAppsRequest.access$getInitialAppsResultParser$p(this.this$0), (Function1<? super String, okhttp3.Response>)((Function1)new Function1<String, okhttp3.Response>((Object)this.this$0){

                    @NotNull
                    public final okhttp3.Response invoke(@NotNull String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return GetSimilarAppsRequest.access$executeAppsRequest((GetSimilarAppsRequest)this.receiver, p0);
                    }
                }), GetSimilarAppsRequest.access$getAppsResultParser$p(this.this$0));
            }
        });
    }

    private final okhttp3.Response executeInitialAppsRequest() {
        String clusterUrl = this.getClusterUrl();
        okhttp3.Request request = new Request.Builder().url(clusterUrl).get().build();
        OkHttpClient okHttpClient = this.httpClient;
        okhttp3.Request p0 = request;
        boolean bl = false;
        return okHttpClient.newCall(p0).execute();
    }

    private final okhttp3.Response executeAppsRequest(String token) {
        okhttp3.Request request = this.appsLoadingRequestFactory.create(new AppsLoadingRequestFactory.Input(50, token, this.params.getCountry(), this.params.getLanguage()));
        OkHttpClient okHttpClient = this.httpClient;
        okhttp3.Request p0 = request;
        boolean bl = false;
        return okHttpClient.newCall(p0).execute();
    }

    private final String getClusterUrl() {
        return (String)RequestUtilsKt.consumeSafely(this.executeClusterUrlRequest(), (Function1)new Function1<okhttp3.Response, String>(this){
            final /* synthetic */ GetSimilarAppsRequest this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull okhttp3.Response response) {
                StringBuilder stringBuilder;
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (!response.isSuccessful()) {
                    throw ScraperErrorKt.httpError(response);
                }
                String rawBody = OkHttpExtensionsKt.requireBody(response).string();
                String clusterUrl = (String)GetSimilarAppsRequest.access$getClusterUrlResultParser$p(this.this$0).parse(rawBody);
                GetSimilarAppsRequest getSimilarAppsRequest = this.this$0;
                StringBuilder $this$invoke_u24lambda_u2d0 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$invoke_u24lambda_u2d0.append(GetSimilarAppsRequest.access$getBaseUrl$p(getSimilarAppsRequest)).append(clusterUrl);
                $this$invoke_u24lambda_u2d0.append("&gl=").append(GetSimilarAppsRequest.access$getParams$p(getSimilarAppsRequest).getCountry());
                $this$invoke_u24lambda_u2d0.append("&hl=").append(GetSimilarAppsRequest.access$getParams$p(getSimilarAppsRequest).getLanguage());
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                return string;
            }
        });
    }

    private final okhttp3.Response executeClusterUrlRequest() {
        okhttp3.Request request = new Request.Builder().url(this.createClusterRequestUrl()).get().build();
        OkHttpClient okHttpClient = this.httpClient;
        okhttp3.Request p0 = request;
        boolean bl = false;
        return okHttpClient.newCall(p0).execute();
    }

    private final String createClusterRequestUrl() {
        StringBuilder stringBuilder;
        String appId = UriUtilsKt.encode-7Vh2N4I(UriComponent.constructor-impl(this.params.getAppId()));
        StringBuilder $this$createClusterRequestUrl_u24lambda_u2d2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createClusterRequestUrl_u24lambda_u2d2.append(this.baseUrl).append("/store/apps/details");
        $this$createClusterRequestUrl_u24lambda_u2d2.append("?id=").append(appId);
        $this$createClusterRequestUrl_u24lambda_u2d2.append("&hl=").append(this.params.getLanguage());
        $this$createClusterRequestUrl_u24lambda_u2d2.append("&gl=").append(this.params.getCountry());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static final /* synthetic */ GetSimilarAppsParams access$getParams$p(GetSimilarAppsRequest $this) {
        return $this.params;
    }

    public static final /* synthetic */ okhttp3.Response access$executeInitialAppsRequest(GetSimilarAppsRequest $this) {
        return $this.executeInitialAppsRequest();
    }

    public static final /* synthetic */ ResultParser access$getInitialAppsResultParser$p(GetSimilarAppsRequest $this) {
        return $this.initialAppsResultParser;
    }

    public static final /* synthetic */ okhttp3.Response access$executeAppsRequest(GetSimilarAppsRequest $this, String token) {
        return $this.executeAppsRequest(token);
    }

    public static final /* synthetic */ ResultParser access$getAppsResultParser$p(GetSimilarAppsRequest $this) {
        return $this.appsResultParser;
    }

    public static final /* synthetic */ ResultParser access$getClusterUrlResultParser$p(GetSimilarAppsRequest $this) {
        return $this.clusterUrlResultParser;
    }

    public static final /* synthetic */ String access$getBaseUrl$p(GetSimilarAppsRequest $this) {
        return $this.baseUrl;
    }
}

