/*
 * Decompiled with CFR 0.152.
 */
package com.arthurivanets.googleplayscraper.requests;

import com.arthurivanets.googleplayscraper.requests.GetAppDetailsParams;
import com.arthurivanets.googleplayscraper.requests.GetAppPermissionsParams;
import com.arthurivanets.googleplayscraper.requests.GetAppReviewsParams;
import com.arthurivanets.googleplayscraper.requests.GetAppsParams;
import com.arthurivanets.googleplayscraper.requests.GetDeveloperAppsParams;
import com.arthurivanets.googleplayscraper.requests.GetSimilarAppsParams;
import com.arthurivanets.googleplayscraper.requests.RequestParamsValidator;
import com.arthurivanets.googleplayscraper.requests.SearchAppsParams;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bJ\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\tJ\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nJ\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000bJ\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/arthurivanets/googleplayscraper/requests/RequestParamsValidator;", "", "()V", "validate", "", "params", "Lcom/arthurivanets/googleplayscraper/requests/GetAppDetailsParams;", "Lcom/arthurivanets/googleplayscraper/requests/GetAppPermissionsParams;", "Lcom/arthurivanets/googleplayscraper/requests/GetAppReviewsParams;", "Lcom/arthurivanets/googleplayscraper/requests/GetAppsParams;", "Lcom/arthurivanets/googleplayscraper/requests/GetDeveloperAppsParams;", "Lcom/arthurivanets/googleplayscraper/requests/GetSimilarAppsParams;", "Lcom/arthurivanets/googleplayscraper/requests/SearchAppsParams;", "validateAppId", "appId", "", "validateCountry", "country", "validateDevId", "devId", "validateLanguage", "language", "validateLimit", "limit", "", "Companion", "google-play-scraper"})
public final class RequestParamsValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<Regex> REGEX_APP_ID$delegate = LazyKt.lazy((Function0)Companion.REGEX_APP_ID.2.INSTANCE);
    @NotNull
    private static final Lazy<Regex> REGEX_COUNTRY_CODE$delegate = LazyKt.lazy((Function0)Companion.REGEX_COUNTRY_CODE.2.INSTANCE);
    @NotNull
    private static final Lazy<Regex> REGEX_LANGUAGE$delegate = LazyKt.lazy((Function0)Companion.REGEX_LANGUAGE.2.INSTANCE);

    public final void validate(@NotNull GetAppDetailsParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.validateAppId(params.getAppId());
        this.validateCountry(params.getCountry());
        this.validateLanguage(params.getLanguage());
    }

    public final void validate(@NotNull GetDeveloperAppsParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.validateDevId(params.getDevId());
        this.validateCountry(params.getCountry());
        this.validateLanguage(params.getLanguage());
        this.validateLimit(params.getLimit());
    }

    public final void validate(@NotNull GetSimilarAppsParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.validateAppId(params.getAppId());
        this.validateCountry(params.getCountry());
        this.validateLanguage(params.getLanguage());
        this.validateLimit(params.getLimit());
    }

    public final void validate(@NotNull GetAppsParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.validateCountry(params.getCountry());
        this.validateLanguage(params.getLanguage());
        this.validateLimit(params.getLimit());
    }

    public final void validate(@NotNull SearchAppsParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (!(!StringsKt.isBlank((CharSequence)params.getQuery()))) {
            boolean bl = false;
            String string = "The query must not be blank";
            throw new IllegalArgumentException(string.toString());
        }
        this.validateCountry(params.getCountry());
        this.validateLanguage(params.getLanguage());
        this.validateLimit(params.getLimit());
    }

    public final void validate(@NotNull GetAppPermissionsParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.validateAppId(params.getAppId());
        this.validateLanguage(params.getLanguage());
    }

    public final void validate(@NotNull GetAppReviewsParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.validateAppId(params.getAppId());
        this.validateCountry(params.getCountry());
        this.validateLanguage(params.getLanguage());
        this.validateLimit(params.getLimit());
    }

    private final void validateAppId(String appId) {
        CharSequence charSequence = appId;
        if (!RequestParamsValidator.Companion.getREGEX_APP_ID().matches(charSequence)) {
            boolean bl = false;
            String string = "Invalid appId [ " + appId + " ].";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void validateCountry(String country) {
        CharSequence charSequence = country;
        if (!RequestParamsValidator.Companion.getREGEX_COUNTRY_CODE().matches(charSequence)) {
            boolean bl = false;
            String string = "Invalid country code [ " + country + " ]";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void validateLanguage(String language) {
        CharSequence charSequence = language;
        if (!RequestParamsValidator.Companion.getREGEX_LANGUAGE().matches(charSequence)) {
            boolean bl = false;
            String string = "Invalid language code [ " + language + " ]";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void validateDevId(String devId) {
        if (!(!StringsKt.isBlank((CharSequence)devId))) {
            boolean bl = false;
            String string = "The developer id must not be blank.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void validateLimit(int limit) {
        if (!(limit > 0)) {
            boolean bl = false;
            String string = "The limit must be >= 0.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006R\u001b\u0010\f\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\b\u001a\u0004\b\r\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/arthurivanets/googleplayscraper/requests/RequestParamsValidator$Companion;", "", "()V", "REGEX_APP_ID", "Lkotlin/text/Regex;", "getREGEX_APP_ID", "()Lkotlin/text/Regex;", "REGEX_APP_ID$delegate", "Lkotlin/Lazy;", "REGEX_COUNTRY_CODE", "getREGEX_COUNTRY_CODE", "REGEX_COUNTRY_CODE$delegate", "REGEX_LANGUAGE", "getREGEX_LANGUAGE", "REGEX_LANGUAGE$delegate", "google-play-scraper"})
    public static final class Companion {
        private Companion() {
        }

        private final Regex getREGEX_APP_ID() {
            Lazy lazy = REGEX_APP_ID$delegate;
            return (Regex)lazy.getValue();
        }

        private final Regex getREGEX_COUNTRY_CODE() {
            Lazy lazy = REGEX_COUNTRY_CODE$delegate;
            return (Regex)lazy.getValue();
        }

        private final Regex getREGEX_LANGUAGE() {
            Lazy lazy = REGEX_LANGUAGE$delegate;
            return (Regex)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

