/*
 * Decompiled with CFR 0.152.
 */
package com.arthurivanets.googleplayscraper.requests;

import com.arthurivanets.googleplayscraper.model.App;
import com.arthurivanets.googleplayscraper.parsers.ResultParser;
import com.arthurivanets.googleplayscraper.requests.AppsLoadingRequestFactory;
import com.arthurivanets.googleplayscraper.requests.Request;
import com.arthurivanets.googleplayscraper.requests.Response;
import com.arthurivanets.googleplayscraper.requests.ResponseExtensionsKt;
import com.arthurivanets.googleplayscraper.requests.SearchAppsParams;
import com.arthurivanets.googleplayscraper.requests.SearchAppsRequest;
import com.arthurivanets.googleplayscraper.util.OkHttpExtensionsKt;
import com.arthurivanets.googleplayscraper.util.PagedResult;
import com.arthurivanets.googleplayscraper.util.RequestUtilsKt;
import com.arthurivanets.googleplayscraper.util.ScraperError;
import com.arthurivanets.googleplayscraper.util.UriComponent;
import com.arthurivanets.googleplayscraper.util.UriUtilsKt;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u001bBe\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u001e\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u000e0\r\u0012\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0007H\u0002J\u001a\u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/arthurivanets/googleplayscraper/requests/SearchAppsRequest;", "Lcom/arthurivanets/googleplayscraper/requests/Request;", "", "Lcom/arthurivanets/googleplayscraper/model/App;", "params", "Lcom/arthurivanets/googleplayscraper/requests/SearchAppsParams;", "baseUrl", "", "httpClient", "Lokhttp3/OkHttpClient;", "appsLoadingRequestFactory", "Lcom/arthurivanets/googleplayscraper/requests/AppsLoadingRequestFactory;", "initialRequestResultParser", "Lcom/arthurivanets/googleplayscraper/parsers/ResultParser;", "Lcom/arthurivanets/googleplayscraper/util/PagedResult;", "requestResultParser", "(Lcom/arthurivanets/googleplayscraper/requests/SearchAppsParams;Ljava/lang/String;Lokhttp3/OkHttpClient;Lcom/arthurivanets/googleplayscraper/requests/AppsLoadingRequestFactory;Lcom/arthurivanets/googleplayscraper/parsers/ResultParser;Lcom/arthurivanets/googleplayscraper/parsers/ResultParser;)V", "createInitialRequestUrl", "execute", "Lcom/arthurivanets/googleplayscraper/requests/Response;", "Lcom/arthurivanets/googleplayscraper/util/ScraperError;", "executeInitialRequest", "Lokhttp3/Response;", "executeRequest", "token", "generateRandomAndroidId", "", "Companion", "google-play-scraper"})
public final class SearchAppsRequest
implements Request<List<? extends App>> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final SearchAppsParams params;
    @NotNull
    private final String baseUrl;
    @NotNull
    private final OkHttpClient httpClient;
    @NotNull
    private final AppsLoadingRequestFactory appsLoadingRequestFactory;
    @NotNull
    private final ResultParser<String, PagedResult<List<App>>> initialRequestResultParser;
    @NotNull
    private final ResultParser<String, PagedResult<List<App>>> requestResultParser;
    @Deprecated
    @NotNull
    private static final Lazy<Pattern> CLUSTER_PAGE_PATTERN$delegate = LazyKt.lazy((Function0)Companion.CLUSTER_PAGE_PATTERN.2.INSTANCE);

    public SearchAppsRequest(@NotNull SearchAppsParams params, @NotNull String baseUrl, @NotNull OkHttpClient httpClient2, @NotNull AppsLoadingRequestFactory appsLoadingRequestFactory2, @NotNull ResultParser<String, PagedResult<List<App>>> initialRequestResultParser, @NotNull ResultParser<String, PagedResult<List<App>>> requestResultParser) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)httpClient2, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)appsLoadingRequestFactory2, (String)"appsLoadingRequestFactory");
        Intrinsics.checkNotNullParameter(initialRequestResultParser, (String)"initialRequestResultParser");
        Intrinsics.checkNotNullParameter(requestResultParser, (String)"requestResultParser");
        this.params = params;
        this.baseUrl = baseUrl;
        this.httpClient = httpClient2;
        this.appsLoadingRequestFactory = appsLoadingRequestFactory2;
        this.initialRequestResultParser = initialRequestResultParser;
        this.requestResultParser = requestResultParser;
    }

    @Override
    @NotNull
    public Response<List<App>, ScraperError> execute() {
        return ResponseExtensionsKt.response((Function0)new Function0<List<? extends App>>(this){
            final /* synthetic */ SearchAppsRequest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<App> invoke() {
                return RequestUtilsKt.fetchContinuously(SearchAppsRequest.access$getParams$p(this.this$0).getLimit(), (Function0<okhttp3.Response>)((Function0)new Function0<okhttp3.Response>((Object)this.this$0){

                    @NotNull
                    public final okhttp3.Response invoke() {
                        return SearchAppsRequest.access$executeInitialRequest((SearchAppsRequest)this.receiver);
                    }
                }), SearchAppsRequest.access$getInitialRequestResultParser$p(this.this$0), (Function1<? super String, okhttp3.Response>)((Function1)new Function1<String, okhttp3.Response>((Object)this.this$0){

                    @NotNull
                    public final okhttp3.Response invoke(@NotNull String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return SearchAppsRequest.access$executeRequest((SearchAppsRequest)this.receiver, p0);
                    }
                }), SearchAppsRequest.access$getRequestResultParser$p(this.this$0));
            }
        });
    }

    private final okhttp3.Response executeInitialRequest() {
        okhttp3.Response response;
        okhttp3.Response response2 = SearchAppsRequest.executeInitialRequest$executeRequest(this, this.createInitialRequestUrl());
        if (response2.isSuccessful()) {
            String body = OkHttpExtensionsKt.peekBody(response2).string();
            Matcher matcher = SearchAppsRequest.Companion.getCLUSTER_PAGE_PATTERN().matcher(body);
            if (matcher.find()) {
                RequestUtilsKt.closeSafely(response2);
                response = SearchAppsRequest.executeInitialRequest$executeRequest(this, Intrinsics.stringPlus((String)this.baseUrl, (Object)matcher.group(1)));
            } else {
                response = response2;
            }
        } else {
            response = response2;
        }
        return response;
    }

    private final String createInitialRequestUrl() {
        StringBuilder stringBuilder;
        String query = UriUtilsKt.encode-7Vh2N4I(UriComponent.constructor-impl(this.params.getQuery()));
        StringBuilder $this$createInitialRequestUrl_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createInitialRequestUrl_u24lambda_u2d0.append(this.baseUrl).append("/store/search");
        $this$createInitialRequestUrl_u24lambda_u2d0.append("?q=").append(query);
        $this$createInitialRequestUrl_u24lambda_u2d0.append("&c=apps");
        $this$createInitialRequestUrl_u24lambda_u2d0.append("&hl=").append(this.params.getLanguage());
        $this$createInitialRequestUrl_u24lambda_u2d0.append("&gl=").append(this.params.getCountry());
        $this$createInitialRequestUrl_u24lambda_u2d0.append("&androidId=").append(this.generateRandomAndroidId());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final okhttp3.Response executeRequest(String token) {
        okhttp3.Request request = this.appsLoadingRequestFactory.create(new AppsLoadingRequestFactory.Input(50, token, this.params.getCountry(), this.params.getLanguage()));
        OkHttpClient okHttpClient = this.httpClient;
        okhttp3.Request p0 = request;
        boolean bl = false;
        return okHttpClient.newCall(p0).execute();
    }

    private final long generateRandomAndroidId() {
        LongRange idRange = new LongRange(1L, 1000000000000000000L);
        return RangesKt.random((LongRange)idRange, (Random)((Random)Random.Default));
    }

    private static final okhttp3.Response executeInitialRequest$executeRequest(SearchAppsRequest this$0, String url) {
        okhttp3.Request request = new Request.Builder().url(url).get().build();
        OkHttpClient okHttpClient = this$0.httpClient;
        okhttp3.Request p0 = request;
        boolean bl = false;
        return okHttpClient.newCall(p0).execute();
    }

    public static final /* synthetic */ SearchAppsParams access$getParams$p(SearchAppsRequest $this) {
        return $this.params;
    }

    public static final /* synthetic */ okhttp3.Response access$executeInitialRequest(SearchAppsRequest $this) {
        return $this.executeInitialRequest();
    }

    public static final /* synthetic */ ResultParser access$getInitialRequestResultParser$p(SearchAppsRequest $this) {
        return $this.initialRequestResultParser;
    }

    public static final /* synthetic */ okhttp3.Response access$executeRequest(SearchAppsRequest $this, String token) {
        return $this.executeRequest(token);
    }

    public static final /* synthetic */ ResultParser access$getRequestResultParser$p(SearchAppsRequest $this) {
        return $this.requestResultParser;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R#\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/arthurivanets/googleplayscraper/requests/SearchAppsRequest$Companion;", "", "()V", "CLUSTER_PAGE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getCLUSTER_PAGE_PATTERN", "()Ljava/util/regex/Pattern;", "CLUSTER_PAGE_PATTERN$delegate", "Lkotlin/Lazy;", "google-play-scraper"})
    private static final class Companion {
        private Companion() {
        }

        private final Pattern getCLUSTER_PAGE_PATTERN() {
            Lazy lazy = CLUSTER_PAGE_PATTERN$delegate;
            return (Pattern)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

