/*
 * Decompiled with CFR 0.152.
 */
package com.arthurivanets.googleplayscraper.util;

import com.arthurivanets.googleplayscraper.util.JsonNormalizer;
import com.arthurivanets.googleplayscraper.util.ResponseJsonExtractor;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/arthurivanets/googleplayscraper/util/AppsResponseJsonExtractor;", "Lcom/arthurivanets/googleplayscraper/util/ResponseJsonExtractor;", "gson", "Lcom/google/gson/Gson;", "jsonNormalizer", "Lcom/arthurivanets/googleplayscraper/util/JsonNormalizer;", "defaultResponseJsonExtractor", "(Lcom/google/gson/Gson;Lcom/arthurivanets/googleplayscraper/util/JsonNormalizer;Lcom/arthurivanets/googleplayscraper/util/ResponseJsonExtractor;)V", "extract", "Lcom/google/gson/JsonElement;", "rawResponse", "", "google-play-scraper"})
public final class AppsResponseJsonExtractor
implements ResponseJsonExtractor {
    @NotNull
    private final Gson gson;
    @NotNull
    private final JsonNormalizer jsonNormalizer;
    @NotNull
    private final ResponseJsonExtractor defaultResponseJsonExtractor;

    public AppsResponseJsonExtractor(@NotNull Gson gson2, @NotNull JsonNormalizer jsonNormalizer2, @NotNull ResponseJsonExtractor defaultResponseJsonExtractor) {
        Intrinsics.checkNotNullParameter((Object)gson2, (String)"gson");
        Intrinsics.checkNotNullParameter((Object)jsonNormalizer2, (String)"jsonNormalizer");
        Intrinsics.checkNotNullParameter((Object)defaultResponseJsonExtractor, (String)"defaultResponseJsonExtractor");
        this.gson = gson2;
        this.jsonNormalizer = jsonNormalizer2;
        this.defaultResponseJsonExtractor = defaultResponseJsonExtractor;
    }

    @Override
    @NotNull
    public JsonElement extract(@NotNull String rawResponse) {
        JsonElement extractedJson;
        JsonElement jsonElement;
        Object object;
        Intrinsics.checkNotNullParameter((Object)rawResponse, (String)"rawResponse");
        if (!(!StringsKt.isBlank((CharSequence)rawResponse))) {
            boolean bl = false;
            String string = "The Raw Response MUST BE a non-blank String";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            JsonElement jsonElement2;
            String[] stringArray = new String[]{"\n"};
            object = (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)rawResponse, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)3);
            if (object == null) {
                jsonElement2 = null;
            } else {
                Object potentiallyJsonString = object;
                boolean bl = false;
                stringArray = (String[])this.gson.fromJson((String)potentiallyJsonString, JsonElement.class);
                if (stringArray == null) {
                    jsonElement2 = null;
                } else {
                    String[] stringArray2 = stringArray;
                    JsonNormalizer jsonNormalizer2 = this.jsonNormalizer;
                    String[] p0 = stringArray2;
                    boolean bl2 = false;
                    jsonElement2 = jsonNormalizer2.normalize((JsonElement)p0);
                }
            }
            object = jsonElement2;
        }
        catch (Exception error) {
            object = null;
        }
        if ((jsonElement = (extractedJson = object)) == null) {
            jsonElement = this.defaultResponseJsonExtractor.extract(rawResponse);
        }
        return jsonElement;
    }
}

