/*
 * Decompiled with CFR 0.152.
 */
package com.arthurivanets.googleplayscraper.util;

import com.arthurivanets.googleplayscraper.util.JsonNormalizer;
import com.arthurivanets.googleplayscraper.util.ResponseJsonExtractor;
import com.arthurivanets.googleplayscraper.util.ScriptDataParser;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/arthurivanets/googleplayscraper/util/DefaultResponseJsonExtractor;", "Lcom/arthurivanets/googleplayscraper/util/ResponseJsonExtractor;", "gson", "Lcom/google/gson/Gson;", "scriptDataParser", "Lcom/arthurivanets/googleplayscraper/util/ScriptDataParser;", "jsonNormalizer", "Lcom/arthurivanets/googleplayscraper/util/JsonNormalizer;", "(Lcom/google/gson/Gson;Lcom/arthurivanets/googleplayscraper/util/ScriptDataParser;Lcom/arthurivanets/googleplayscraper/util/JsonNormalizer;)V", "extract", "Lcom/google/gson/JsonElement;", "rawResponse", "", "google-play-scraper"})
public final class DefaultResponseJsonExtractor
implements ResponseJsonExtractor {
    @NotNull
    private final Gson gson;
    @NotNull
    private final ScriptDataParser scriptDataParser;
    @NotNull
    private final JsonNormalizer jsonNormalizer;

    public DefaultResponseJsonExtractor(@NotNull Gson gson2, @NotNull ScriptDataParser scriptDataParser, @NotNull JsonNormalizer jsonNormalizer2) {
        Intrinsics.checkNotNullParameter((Object)gson2, (String)"gson");
        Intrinsics.checkNotNullParameter((Object)scriptDataParser, (String)"scriptDataParser");
        Intrinsics.checkNotNullParameter((Object)jsonNormalizer2, (String)"jsonNormalizer");
        this.gson = gson2;
        this.scriptDataParser = scriptDataParser;
        this.jsonNormalizer = jsonNormalizer2;
    }

    @Override
    @NotNull
    public JsonElement extract(@NotNull String rawResponse) {
        JsonElement jsonElement;
        Intrinsics.checkNotNullParameter((Object)rawResponse, (String)"rawResponse");
        if (!(!StringsKt.isBlank((CharSequence)rawResponse))) {
            boolean bl = false;
            String string = "The Raw Response MUST BE a non-blank String";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            String string;
            if (rawResponse.length() > 6) {
                String string2 = rawResponse.substring(6);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                string = string2;
            } else {
                string = rawResponse;
            }
            String potentiallyJsonString = string;
            JsonElement result = (JsonElement)this.gson.fromJson(potentiallyJsonString, JsonElement.class);
            boolean bl = false;
            jsonElement = result.isJsonPrimitive() ? (JsonElement)this.scriptDataParser.parse(rawResponse) : result;
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"{\n            val potent\u2026t\n            }\n        }");
        }
        catch (Exception error) {
            jsonElement = (JsonElement)this.scriptDataParser.parse(rawResponse);
        }
        JsonElement rawJson = jsonElement;
        return this.jsonNormalizer.normalize(rawJson);
    }
}

