/*
 * Decompiled with CFR 0.152.
 */
package com.arthurivanets.googleplayscraper.util;

import com.arthurivanets.googleplayscraper.util.DefaultScriptDataParser;
import com.arthurivanets.googleplayscraper.util.ScriptDataParser;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/arthurivanets/googleplayscraper/util/DefaultScriptDataParser;", "Lcom/arthurivanets/googleplayscraper/util/ScriptDataParser;", "gson", "Lcom/google/gson/Gson;", "(Lcom/google/gson/Gson;)V", "parse", "Lcom/google/gson/JsonObject;", "rawHtmlResponse", "", "Companion", "google-play-scraper"})
public final class DefaultScriptDataParser
implements ScriptDataParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Gson gson;
    @NotNull
    private static final Lazy<Pattern> PATTERN_SCRIPT$delegate = LazyKt.lazy((Function0)Companion.PATTERN_SCRIPT.2.INSTANCE);
    @NotNull
    private static final Lazy<Pattern> PATTERN_KEY$delegate = LazyKt.lazy((Function0)Companion.PATTERN_KEY.2.INSTANCE);
    @NotNull
    private static final Lazy<Pattern> PATTERN_VALUE$delegate = LazyKt.lazy((Function0)Companion.PATTERN_VALUE.2.INSTANCE);

    public DefaultScriptDataParser(@NotNull Gson gson2) {
        Intrinsics.checkNotNullParameter((Object)gson2, (String)"gson");
        this.gson = gson2;
    }

    @Override
    @NotNull
    public JsonObject parse(@NotNull String rawHtmlResponse) {
        Intrinsics.checkNotNullParameter((Object)rawHtmlResponse, (String)"rawHtmlResponse");
        if (!(!StringsKt.isBlank((CharSequence)rawHtmlResponse))) {
            boolean $i$a$-require-DefaultScriptDataParser$parse$22 = false;
            String $i$a$-require-DefaultScriptDataParser$parse$22 = "HTML Response MUST a Non-empty string";
            throw new IllegalArgumentException($i$a$-require-DefaultScriptDataParser$parse$22.toString());
        }
        JsonObject outObject = new JsonObject();
        Matcher scriptMatcher = DefaultScriptDataParser.Companion.getPATTERN_SCRIPT().matcher(rawHtmlResponse);
        while (scriptMatcher.find()) {
            String matchedData = scriptMatcher.group();
            Matcher keyMatcher = DefaultScriptDataParser.Companion.getPATTERN_KEY().matcher(matchedData);
            Matcher valueMatcher = DefaultScriptDataParser.Companion.getPATTERN_VALUE().matcher(matchedData);
            if (!keyMatcher.find() || !valueMatcher.find()) continue;
            String key = keyMatcher.group(1);
            String value = valueMatcher.group(1);
            JsonElement jsonValue = (JsonElement)this.gson.fromJson(value, JsonElement.class);
            outObject.add(key, jsonValue);
        }
        return outObject;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R#\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R#\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\u000b\u0010\u0007R#\u0010\r\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\t\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/arthurivanets/googleplayscraper/util/DefaultScriptDataParser$Companion;", "", "()V", "PATTERN_KEY", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getPATTERN_KEY", "()Ljava/util/regex/Pattern;", "PATTERN_KEY$delegate", "Lkotlin/Lazy;", "PATTERN_SCRIPT", "getPATTERN_SCRIPT", "PATTERN_SCRIPT$delegate", "PATTERN_VALUE", "getPATTERN_VALUE", "PATTERN_VALUE$delegate", "google-play-scraper"})
    public static final class Companion {
        private Companion() {
        }

        private final Pattern getPATTERN_SCRIPT() {
            Lazy lazy = PATTERN_SCRIPT$delegate;
            return (Pattern)lazy.getValue();
        }

        private final Pattern getPATTERN_KEY() {
            Lazy lazy = PATTERN_KEY$delegate;
            return (Pattern)lazy.getValue();
        }

        private final Pattern getPATTERN_VALUE() {
            Lazy lazy = PATTERN_VALUE$delegate;
            return (Pattern)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

