/*
 * Decompiled with CFR 0.152.
 */
package com.arthurivanets.googleplayscraper.util;

import com.arthurivanets.googleplayscraper.util.JsonNormalizer;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J2\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/arthurivanets/googleplayscraper/util/IterativeJsonNormalizer;", "Lcom/arthurivanets/googleplayscraper/util/JsonNormalizer;", "gson", "Lcom/google/gson/Gson;", "(Lcom/google/gson/Gson;)V", "normalize", "Lcom/google/gson/JsonElement;", "json", "processElement", "", "outPendingTraversals", "Ljava/util/LinkedList;", "element", "replacementAction", "Lkotlin/Function1;", "google-play-scraper"})
public final class IterativeJsonNormalizer
implements JsonNormalizer {
    @NotNull
    private final Gson gson;

    public IterativeJsonNormalizer(@NotNull Gson gson2) {
        Intrinsics.checkNotNullParameter((Object)gson2, (String)"gson");
        this.gson = gson2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsonElement normalize(@NotNull JsonElement json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (json.isJsonPrimitive() || json.isJsonNull()) {
            return json;
        }
        JsonElement normalizedJson = json.deepCopy();
        LinkedList<JsonElement> pendingTraversals = new LinkedList<JsonElement>();
        pendingTraversals.push(normalizedJson);
        while (!((Collection)pendingTraversals).isEmpty()) {
            Iterable $this$forEachIndexed$iv;
            JsonElement traversal = (JsonElement)pendingTraversals.pop();
            if (traversal.isJsonArray()) {
                JsonArray jsonArray = traversal.getAsJsonArray();
                Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"jsonArray");
                $this$forEachIndexed$iv = (Iterable)jsonArray;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void child;
                    int n = index$iv;
                    index$iv = n + 1;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    JsonElement jsonElement = (JsonElement)item$iv;
                    int index = n;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                    this.processElement(pendingTraversals, (JsonElement)child, (Function1<? super JsonElement, Unit>)((Function1)new Function1<JsonElement, Unit>(jsonArray, index){
                        final /* synthetic */ JsonArray $jsonArray;
                        final /* synthetic */ int $index;
                        {
                            this.$jsonArray = $jsonArray;
                            this.$index = $index;
                            super(1);
                        }

                        public final void invoke(@NotNull JsonElement newElement) {
                            Intrinsics.checkNotNullParameter((Object)newElement, (String)"newElement");
                            this.$jsonArray.set(this.$index, newElement);
                        }
                    }));
                }
                continue;
            }
            if (!traversal.isJsonObject()) continue;
            JsonObject jsonObject = traversal.getAsJsonObject();
            $this$forEachIndexed$iv = jsonObject.entrySet();
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEachIndexed$iv, (String)"jsonObject.entrySet()");
            Iterable $this$forEach$iv = $this$forEachIndexed$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry $dstr$key$child = (Map.Entry)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)$dstr$key$child, (String)"(key, child)");
                String key = (String)$dstr$key$child.getKey();
                JsonElement child = (JsonElement)$dstr$key$child.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                this.processElement(pendingTraversals, child, (Function1<? super JsonElement, Unit>)((Function1)new Function1<JsonElement, Unit>(jsonObject, key){
                    final /* synthetic */ JsonObject $jsonObject;
                    final /* synthetic */ String $key;
                    {
                        this.$jsonObject = $jsonObject;
                        this.$key = $key;
                        super(1);
                    }

                    public final void invoke(@NotNull JsonElement newElement) {
                        Intrinsics.checkNotNullParameter((Object)newElement, (String)"newElement");
                        this.$jsonObject.add(this.$key, newElement);
                    }
                }));
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)normalizedJson, (String)"normalizedJson");
        return normalizedJson;
    }

    private final void processElement(LinkedList<JsonElement> outPendingTraversals, JsonElement element, Function1<? super JsonElement, Unit> replacementAction) {
        JsonPrimitive primitive;
        if (element.isJsonArray() || element.isJsonObject()) {
            outPendingTraversals.push(element);
        } else if (element.isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isString()) {
            try {
                JsonElement normalizedPrimitive = (JsonElement)this.gson.fromJson(primitive.getAsString(), JsonElement.class);
                if (normalizedPrimitive.isJsonArray() || normalizedPrimitive.isJsonObject()) {
                    Intrinsics.checkNotNullExpressionValue((Object)normalizedPrimitive, (String)"normalizedPrimitive");
                    replacementAction.invoke((Object)normalizedPrimitive);
                    outPendingTraversals.push(normalizedPrimitive);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

