/*
 * Decompiled with CFR 0.152.
 */
package com.arthurivanets.googleplayscraper.util;

import com.arthurivanets.googleplayscraper.parsers.ResultParser;
import com.arthurivanets.googleplayscraper.util.OkHttpExtensionsKt;
import com.arthurivanets.googleplayscraper.util.PagedResult;
import com.arthurivanets.googleplayscraper.util.PendingRequest;
import com.arthurivanets.googleplayscraper.util.ScraperErrorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a\u008d\u0001\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u001e\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u000b0\t2!\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00070\r2\u001e\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u000b0\tH\u0000\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0007H\u0000\u001a+\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u0015*\u00020\u00072\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u00150\rH\u0000\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"fetchContinuously", "", "T", "itemCount", "", "initialRequestExecutor", "Lkotlin/Function0;", "Lokhttp3/Response;", "initialRequestResultParser", "Lcom/arthurivanets/googleplayscraper/parsers/ResultParser;", "", "Lcom/arthurivanets/googleplayscraper/util/PagedResult;", "subsequentRequestExecutor", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "pagingToken", "subsequentRequestResultParser", "closeSafely", "", "consumeSafely", "R", "block", "(Lokhttp3/Response;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "google-play-scraper"})
public final class RequestUtilsKt {
    @NotNull
    public static final <T> List<T> fetchContinuously(int itemCount, @NotNull Function0<Response> initialRequestExecutor, @NotNull ResultParser<String, PagedResult<List<T>>> initialRequestResultParser, @NotNull Function1<? super String, Response> subsequentRequestExecutor, @NotNull ResultParser<String, PagedResult<List<T>>> subsequentRequestResultParser) {
        Intrinsics.checkNotNullParameter(initialRequestExecutor, (String)"initialRequestExecutor");
        Intrinsics.checkNotNullParameter(initialRequestResultParser, (String)"initialRequestResultParser");
        Intrinsics.checkNotNullParameter(subsequentRequestExecutor, (String)"subsequentRequestExecutor");
        Intrinsics.checkNotNullParameter(subsequentRequestResultParser, (String)"subsequentRequestResultParser");
        List fetchedItems = new ArrayList();
        LinkedList pendingRequests = new LinkedList();
        pendingRequests.offer(new PendingRequest<T>(initialRequestExecutor, initialRequestResultParser));
        while (!((Collection)pendingRequests).isEmpty()) {
            PendingRequest request = (PendingRequest)pendingRequests.poll();
            RequestUtilsKt.consumeSafely((Response)request.getExecutor().invoke(), (Function1)new Function1<Response, Unit>(request, fetchedItems, itemCount, pendingRequests, subsequentRequestResultParser, subsequentRequestExecutor){
                final /* synthetic */ PendingRequest<T> $request;
                final /* synthetic */ List<T> $fetchedItems;
                final /* synthetic */ int $itemCount;
                final /* synthetic */ LinkedList<PendingRequest<T>> $pendingRequests;
                final /* synthetic */ ResultParser<String, PagedResult<List<T>>> $subsequentRequestResultParser;
                final /* synthetic */ Function1<String, Response> $subsequentRequestExecutor;
                {
                    this.$request = $request;
                    this.$fetchedItems = $fetchedItems;
                    this.$itemCount = $itemCount;
                    this.$pendingRequests = $pendingRequests;
                    this.$subsequentRequestResultParser = $subsequentRequestResultParser;
                    this.$subsequentRequestExecutor = $subsequentRequestExecutor;
                    super(1);
                }

                public final void invoke(@NotNull Response response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    if (response.isSuccessful()) {
                        String rawBody = OkHttpExtensionsKt.requireBody(response).string();
                        PagedResult<List<T>> result = this.$request.getResultParser().parse(rawBody);
                        String pagingToken = result.getNextToken();
                        this.$fetchedItems.addAll((Collection)result.getResult());
                        if (this.$fetchedItems.size() < this.$itemCount && pagingToken != null) {
                            this.$pendingRequests.offer(new PendingRequest<T>((Function0<Response>)((Function0)new Function0<Response>(this.$subsequentRequestExecutor, pagingToken){
                                final /* synthetic */ Function1<String, Response> $subsequentRequestExecutor;
                                final /* synthetic */ String $pagingToken;
                                {
                                    this.$subsequentRequestExecutor = $subsequentRequestExecutor;
                                    this.$pagingToken = $pagingToken;
                                    super(0);
                                }

                                @NotNull
                                public final Response invoke() {
                                    return (Response)this.$subsequentRequestExecutor.invoke((Object)this.$pagingToken);
                                }
                            }), this.$subsequentRequestResultParser));
                        }
                    } else {
                        throw ScraperErrorKt.httpError(response);
                    }
                }
            });
        }
        return CollectionsKt.take((Iterable)fetchedItems, (int)itemCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <R> R consumeSafely(@NotNull Response $this$consumeSafely, @NotNull Function1<? super Response, ? extends R> block) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$consumeSafely, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        try {
            object = block.invoke((Object)$this$consumeSafely);
        }
        finally {
            RequestUtilsKt.closeSafely($this$consumeSafely);
        }
        return (R)object;
    }

    public static final void closeSafely(@NotNull Response $this$closeSafely) {
        Intrinsics.checkNotNullParameter((Object)$this$closeSafely, (String)"<this>");
        try {
            if ($this$closeSafely.body() != null) {
                ResponseBody responseBody;
                ResponseBody responseBody2 = responseBody = $this$closeSafely.body();
                if (responseBody2 != null) {
                    responseBody2.close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

