/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.etcd;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Meta;
import com.artipie.asto.Storage;
import com.artipie.asto.UnderLockOperation;
import com.artipie.asto.ValueNotFoundException;
import com.artipie.asto.etcd.EtcdMeta;
import com.artipie.asto.ext.CompletableFutureSupport;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.asto.lock.Lock;
import com.artipie.asto.lock.storage.StorageLock;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.options.GetOption;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class EtcdStorage
implements Storage {
    private static final long MAX_SIZE = 0xA00000L;
    private static final ByteSequence ETCD_ROOT_KEY = ByteSequence.from((String)"\u0000", (Charset)StandardCharsets.UTF_8);
    private final Client client;
    private final String id;

    public EtcdStorage(Client client, String endpoints) {
        this.client = client;
        this.id = String.format("Etcd: %s", endpoints);
    }

    public CompletableFuture<Boolean> exists(Key key) {
        return this.client.getKVClient().get(EtcdStorage.keyToSeq(key), GetOption.newBuilder().withCountOnly(true).build()).thenApply(rsp -> rsp.getCount() > 0L);
    }

    public CompletableFuture<Collection<Key>> list(Key prefix) {
        CompletableFuture future = prefix.equals(Key.ROOT) ? this.client.getKVClient().get(ETCD_ROOT_KEY, GetOption.newBuilder().withKeysOnly(true).withSortOrder(GetOption.SortOrder.ASCEND).withRange(ETCD_ROOT_KEY).build()) : this.client.getKVClient().get(EtcdStorage.keyToSeq(prefix), GetOption.newBuilder().withKeysOnly(true).withSortOrder(GetOption.SortOrder.ASCEND).isPrefix(true).build());
        return future.thenApply(rsp -> rsp.getKvs().stream().map(kv -> new String(kv.getKey().getBytes(), StandardCharsets.UTF_8)).map(str -> new Key.From(str)).distinct().collect(Collectors.toList()));
    }

    public CompletableFuture<Void> save(Key key, Content content) {
        long size = content.size().orElse(0L);
        if (size < 0L || size > 0xA00000L) {
            return new CompletableFutureSupport.Failed((Exception)new ArtipieIOException(String.format("Content size must be in range (0;%d)", 0xA00000L))).get();
        }
        return new PublisherAs(content).bytes().thenApply(ByteSequence::from).thenCompose(data -> this.client.getKVClient().put(EtcdStorage.keyToSeq(key), data)).thenApply(ignore -> null).toCompletableFuture();
    }

    public CompletableFuture<Void> move(Key source, Key destination) {
        return ((CompletableFuture)this.value(source).thenCompose(data -> this.save(destination, (Content)data))).thenCompose(none -> this.delete(source));
    }

    public CompletableFuture<? extends Meta> metadata(Key key) {
        return ((CompletableFuture)((CompletableFuture)this.client.getKVClient().get(EtcdStorage.keyToSeq(key)).thenApply(rsp -> rsp.getKvs().stream().max(Comparator.comparingLong(KeyValue::getVersion)))).thenApply(kv -> (KeyValue)kv.orElseThrow(() -> new ValueNotFoundException(key)))).thenApply(kv -> new EtcdMeta((KeyValue)kv));
    }

    public CompletableFuture<Content> value(Key key) {
        return ((CompletableFuture)((CompletableFuture)this.client.getKVClient().get(EtcdStorage.keyToSeq(key)).thenApply(rsp -> rsp.getKvs().stream().max(Comparator.comparingLong(KeyValue::getVersion)))).thenApply(kv -> ((KeyValue)kv.orElseThrow(() -> new ValueNotFoundException(key))).getValue().getBytes())).thenApply(bytes -> new Content.OneTime((Content)new Content.From(bytes)));
    }

    public CompletableFuture<Void> delete(Key key) {
        return this.client.getKVClient().delete(EtcdStorage.keyToSeq(key)).thenAccept(rsp -> {
            if (rsp.getDeleted() == 0L) {
                throw new ValueNotFoundException(key);
            }
        });
    }

    public <T> CompletionStage<T> exclusively(Key key, Function<Storage, CompletionStage<T>> operation) {
        return new UnderLockOperation((Lock)new StorageLock((Storage)this, key), operation).perform((Storage)this);
    }

    public String identifier() {
        return this.id;
    }

    private static ByteSequence keyToSeq(Key key) {
        return ByteSequence.from((String)key.string(), (Charset)StandardCharsets.UTF_8);
    }
}

