/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.etcd;

import com.artipie.asto.Storage;
import com.artipie.asto.etcd.EtcdStorage;
import com.artipie.asto.factory.ArtipieStorageFactory;
import com.artipie.asto.factory.Config;
import com.artipie.asto.factory.StorageFactory;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.ClientBuilder;
import java.time.Duration;
import java.util.Arrays;

@ArtipieStorageFactory(value="etcd")
public final class EtcdStorageFactory
implements StorageFactory {
    public Storage newStorage(Config cfg) {
        Config connection = new Config.StrictStorageConfig(cfg).config("connection");
        Object[] endpoints = connection.sequence("endpoints").toArray(new String[0]);
        ClientBuilder builder = Client.builder().endpoints((String[])endpoints);
        String sto = connection.string("timeout");
        if (sto != null) {
            builder.connectTimeout(Duration.ofMillis(Integer.parseInt(sto)));
        }
        return new EtcdStorage(builder.build(), Arrays.toString(endpoints));
    }
}

