/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.s3;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Content;
import com.artipie.asto.s3.S3Storage;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Flowable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.cqfn.rio.file.File;
import org.reactivestreams.Publisher;

final class EstimatedContentCompliment {
    private final Content original;
    private final long limit;

    EstimatedContentCompliment(Content original, long limit) {
        this.original = original;
        this.limit = limit;
    }

    EstimatedContentCompliment(Content original) {
        this(original, Long.MAX_VALUE);
    }

    public CompletionStage<Content> estimate() {
        CompletableFuture<Content> res = this.original.size().isPresent() ? CompletableFuture.completedFuture(this.original) : this.readUntilLimit();
        return res;
    }

    private CompletableFuture<Content> readUntilLimit() {
        Path temp;
        try {
            temp = Files.createTempFile(S3Storage.class.getSimpleName(), ".upload.tmp", new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new ArtipieIOException(ex);
        }
        Flowable data = Flowable.fromPublisher((Publisher)new File(temp).content()).doOnError(error -> Files.deleteIfExists(temp));
        return new File(temp).write((Publisher)this.original, new OpenOption[0]).thenCompose(nothing -> ((CompletionStage)data.map(Buffer::remaining).scanWith(() -> 0L, Long::sum).takeUntil(total -> total >= this.limit).lastOrError().to(SingleInterop.get())).toCompletableFuture()).thenApply(last -> {
            Optional<Object> size = last >= this.limit ? Optional.empty() : Optional.of(last);
            return new Content.From(size, (Publisher)data.doAfterTerminate(() -> Files.deleteIfExists(temp)));
        }).toCompletableFuture();
    }
}

