/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.s3;

import com.artipie.asto.Storage;
import com.artipie.asto.factory.ArtipieStorageFactory;
import com.artipie.asto.factory.Config;
import com.artipie.asto.factory.StorageFactory;
import com.artipie.asto.s3.S3Storage;
import java.net.URI;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;

@ArtipieStorageFactory(value="s3")
public final class S3StorageFactory
implements StorageFactory {
    public Storage newStorage(Config cfg) {
        return new S3Storage(S3StorageFactory.s3Client(cfg), new Config.StrictStorageConfig(cfg).string("bucket"), !"false".equals(cfg.string("multipart")), S3StorageFactory.endpoint(cfg).orElse("def endpoint"));
    }

    private static S3AsyncClient s3Client(Config cfg) {
        S3AsyncClientBuilder builder = S3AsyncClient.builder();
        Optional.ofNullable(cfg.string("region")).ifPresent(val -> {
            S3AsyncClientBuilder cfr_ignored_0 = (S3AsyncClientBuilder)builder.region(Region.of((String)val));
        });
        S3StorageFactory.endpoint(cfg).ifPresent(val -> {
            S3AsyncClientBuilder cfr_ignored_0 = (S3AsyncClientBuilder)builder.endpointOverride(URI.create(val));
        });
        S3StorageFactory.setCredentialsProvider(builder, cfg);
        return (S3AsyncClient)builder.build();
    }

    private static void setCredentialsProvider(S3AsyncClientBuilder builder, Config cfg) {
        Config credentials = cfg.config("credentials");
        if (!credentials.isEmpty()) {
            String type = credentials.string("type");
            if ("basic".equals(type)) {
                builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)credentials.string("accessKeyId"), (String)credentials.string("secretAccessKey"))));
            } else {
                throw new IllegalArgumentException(String.format("Unsupported S3 credentials type: %s", type));
            }
        }
    }

    private static Optional<String> endpoint(Config cfg) {
        return Optional.ofNullable(cfg.string("endpoint"));
    }
}

