/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.fs;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.Transaction;
import com.artipie.asto.fs.FileSystemTransaction;
import com.artipie.asto.fs.RxFile;
import com.jcabi.log.Logger;
import hu.akarnokd.rxjava2.interop.CompletableInterop;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.vertx.reactivex.core.file.FileSystem;
import java.nio.ByteBuffer;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;

public final class FileStorage
implements Storage {
    private final Path dir;
    private final FileSystem fls;

    public FileStorage(Path path, FileSystem fls) {
        this.dir = path;
        this.fls = fls;
    }

    @Override
    public CompletableFuture<Boolean> exists(Key key) {
        return ((CompletionStage)Single.fromCallable(() -> {
            Path path = this.path(key);
            return Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0]);
        }).to(SingleInterop.get())).toCompletableFuture();
    }

    @Override
    public CompletableFuture<Collection<Key>> list(Key prefix) {
        return ((CompletionStage)Single.fromCallable(() -> {
            Collection<Object> keys;
            Path path = this.path(prefix);
            if (Files.exists(path, new LinkOption[0])) {
                int dirnamelen = Key.ROOT.equals(prefix) ? path.toString().length() + 1 : path.toString().length() - prefix.string().length();
                keys = Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).map(p -> p.substring(dirnamelen)).map(s -> s.split(FileSystems.getDefault().getSeparator().replace("\\", "\\\\"))).map(Key.From::new).sorted(Comparator.comparing(Key.From::string)).collect(Collectors.toList());
            } else {
                keys = Collections.emptyList();
            }
            Logger.info((Object)this, (String)"Found %d objects by the prefix \"%s\" in %s by %s: %s", (Object[])new Object[]{keys.size(), prefix, this.dir, path, keys});
            return keys;
        }).to(SingleInterop.get())).toCompletableFuture();
    }

    @Override
    public CompletableFuture<Void> save(Key key, Content content) {
        return ((CompletionStage)Single.fromCallable(() -> {
            Path file = this.path(key);
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            return file;
        }).flatMapCompletable(file -> new RxFile((Path)file, this.fls).save((Flowable<ByteBuffer>)Flowable.fromPublisher((Publisher)content))).to(CompletableInterop.await())).thenApply(o -> null).toCompletableFuture();
    }

    @Override
    public CompletableFuture<Void> move(Key source, Key destination) {
        return ((CompletionStage)Single.fromCallable(() -> {
            Path dest = this.path(destination);
            dest.getParent().toFile().mkdirs();
            return dest;
        }).flatMapCompletable(dest -> new RxFile(this.path(source), this.fls).move((Path)dest)).to(CompletableInterop.await())).thenApply(file -> null).toCompletableFuture();
    }

    @Override
    public CompletableFuture<Void> delete(Key key) {
        return ((CompletionStage)new RxFile(this.path(key), this.fls).delete().to(CompletableInterop.await())).toCompletableFuture().thenCompose(ignored -> CompletableFuture.allOf(new CompletableFuture[0]));
    }

    @Override
    public CompletableFuture<Content> value(Key key) {
        return CompletableFuture.supplyAsync(() -> {
            RxFile file = new RxFile(this.path(key), this.fls);
            return new Content.From((Long)file.size().blockingGet(), (Publisher<ByteBuffer>)file.flow());
        });
    }

    @Override
    public CompletableFuture<Transaction> transaction(List<Key> keys) {
        return CompletableFuture.completedFuture(new FileSystemTransaction(this));
    }

    private Path path(Key key) {
        return Paths.get(this.dir.toString(), key.string());
    }
}

