/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.fs;

import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.vertx.core.file.CopyOptions;
import io.vertx.core.file.OpenOptions;
import io.vertx.reactivex.core.Promise;
import io.vertx.reactivex.core.file.FileSystem;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class RxFile {
    private final Path file;
    private final FileSystem fls;

    public RxFile(Path file, FileSystem fls) {
        this.file = file;
        this.fls = fls;
    }

    public Flowable<ByteBuffer> flow() {
        return this.fls.rxOpen(this.file.toString(), new OpenOptions().setRead(true).setWrite(false).setCreate(false)).flatMapPublisher(asyncFile -> {
            Promise promise = Promise.promise();
            Completable completable = Completable.create(emitter -> promise.future().setHandler(event -> {
                if (event.succeeded()) {
                    emitter.onComplete();
                } else {
                    emitter.onError(event.cause());
                }
            }));
            return asyncFile.toFlowable().map(buffer -> ByteBuffer.wrap(buffer.getBytes())).doOnTerminate(() -> asyncFile.rxClose().subscribe(() -> ((Promise)promise).complete())).mergeWith((CompletableSource)completable);
        });
    }

    public Completable save(Flowable<ByteBuffer> flow) {
        return Single.fromCallable(() -> FileChannel.open(this.file, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING)).flatMapCompletable(chan -> flow.reduce(chan, (out, buf) -> {
            while (buf.hasRemaining()) {
                out.write((ByteBuffer)buf);
            }
            return out;
        }).ignoreElement().doOnTerminate(chan::close));
    }

    public Completable move(Path target) {
        return this.fls.rxMove(this.file.toString(), target.toString(), new CopyOptions().setReplaceExisting(true));
    }

    public Completable delete() {
        return this.fls.rxDelete(this.file.toString());
    }

    public Single<Long> size() {
        return Single.fromCallable(() -> Files.size(this.file));
    }
}

