/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.memory;

import com.artipie.asto.Concatenation;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Remaining;
import com.artipie.asto.Storage;
import com.artipie.asto.Transaction;
import com.artipie.asto.memory.InMemoryTransaction;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;

public final class InMemoryStorage
implements Storage {
    private final NavigableMap<String, byte[]> data = new TreeMap<String, byte[]>();

    @Override
    public CompletableFuture<Boolean> exists(Key key) {
        return CompletableFuture.supplyAsync(() -> {
            NavigableMap<String, byte[]> navigableMap = this.data;
            synchronized (navigableMap) {
                return this.data.containsKey(key.string());
            }
        });
    }

    @Override
    public CompletableFuture<Collection<Key>> list(Key root) {
        return CompletableFuture.supplyAsync(() -> {
            NavigableMap<String, byte[]> navigableMap = this.data;
            synchronized (navigableMap) {
                String string;
                String prefix = root.string();
                LinkedList<Key.From> keys = new LinkedList<Key.From>();
                Iterator iterator = this.data.navigableKeySet().tailSet(prefix).iterator();
                while (iterator.hasNext() && (string = (String)iterator.next()).startsWith(prefix)) {
                    keys.add(new Key.From(string));
                }
                return keys;
            }
        });
    }

    @Override
    public CompletableFuture<Void> save(Key key, Content content) {
        return CompletableFuture.runAsync(() -> {
            NavigableMap<String, byte[]> navigableMap = this.data;
            synchronized (navigableMap) {
                this.data.put(key.string(), new Remaining((ByteBuffer)new Concatenation(content).single().blockingGet(), true).bytes());
            }
        });
    }

    @Override
    public CompletableFuture<Void> move(Key source, Key destination) {
        return CompletableFuture.runAsync(() -> {
            NavigableMap<String, byte[]> navigableMap = this.data;
            synchronized (navigableMap) {
                String key = source.string();
                if (!this.data.containsKey(key)) {
                    throw new IllegalArgumentException(String.format("No value for source key: %s", source.string()));
                }
                this.data.put(destination.string(), (byte[])this.data.get(key));
                this.data.remove(source.string());
            }
        });
    }

    @Override
    public CompletableFuture<Content> value(Key key) {
        return CompletableFuture.supplyAsync(() -> {
            NavigableMap<String, byte[]> navigableMap = this.data;
            synchronized (navigableMap) {
                byte[] content = (byte[])this.data.get(key.string());
                if (content == null) {
                    throw new IllegalArgumentException(String.format("No value for key: %s", key.string()));
                }
                return new Content.From(content);
            }
        });
    }

    @Override
    public CompletableFuture<Void> delete(Key key) {
        return CompletableFuture.runAsync(() -> {
            NavigableMap<String, byte[]> navigableMap = this.data;
            synchronized (navigableMap) {
                String str = key.string();
                if (!this.data.containsKey(str)) {
                    throw new IllegalArgumentException(String.format("Key does not exist: %s", str));
                }
                this.data.remove(str);
            }
        });
    }

    @Override
    public CompletableFuture<Transaction> transaction(List<Key> keys) {
        return CompletableFuture.completedFuture(new InMemoryTransaction(this));
    }
}

