/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.blocking;

import com.artipie.asto.Concatenation;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Remaining;
import com.artipie.asto.Storage;
import com.artipie.asto.rx.RxStorage;
import com.artipie.asto.rx.RxStorageWrapper;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.reactivestreams.Publisher;

public class BlockingStorage {
    private final RxStorage storage;

    public BlockingStorage(Storage storage) {
        this.storage = new RxStorageWrapper(storage);
    }

    public boolean exists(Key key) {
        return (Boolean)this.storage.exists(key).blockingGet();
    }

    public Collection<Key> list(Key prefix) {
        return (Collection)this.storage.list(prefix).blockingGet();
    }

    public void save(Key key, byte[] content) {
        this.storage.save(key, new Content.From(content)).blockingAwait();
    }

    public void move(Key source, Key destination) {
        this.storage.move(source, destination).blockingAwait();
    }

    public long size(Key key) {
        return (Long)this.storage.size(key).blockingGet();
    }

    public byte[] value(Key key) {
        return new Remaining((ByteBuffer)this.storage.value(key).flatMap(content -> new Concatenation((Publisher<ByteBuffer>)content).single()).blockingGet(), true).bytes();
    }

    public void delete(Key key) {
        this.storage.delete(key).blockingAwait();
    }
}

