/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.blocking;

import com.artipie.asto.Concatenation;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Remaining;
import com.artipie.asto.Storage;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.reactivestreams.Publisher;

public class BlockingStorage {
    private final Storage storage;

    public BlockingStorage(Storage storage) {
        this.storage = storage;
    }

    public boolean exists(Key key) throws InterruptedException {
        try {
            return this.storage.exists(key).get();
        }
        catch (ExecutionException err) {
            throw new UncheckedExecutionException((Throwable)err);
        }
    }

    public Collection<Key> list(Key prefix) throws InterruptedException {
        try {
            return this.storage.list(prefix).get();
        }
        catch (ExecutionException err) {
            throw new UncheckedExecutionException((Throwable)err);
        }
    }

    public void save(Key key, byte[] content) throws InterruptedException {
        try {
            this.storage.save(key, new Content.From(content)).get();
        }
        catch (ExecutionException err) {
            throw new UncheckedExecutionException((Throwable)err);
        }
    }

    public void move(Key source, Key destination) throws InterruptedException {
        try {
            this.storage.move(source, destination).get();
        }
        catch (ExecutionException err) {
            throw new UncheckedExecutionException((Throwable)err);
        }
    }

    public long size(Key key) throws InterruptedException {
        try {
            return this.storage.size(key).get();
        }
        catch (ExecutionException err) {
            throw new UncheckedExecutionException((Throwable)err);
        }
    }

    public byte[] value(Key key) throws InterruptedException {
        try {
            return new Remaining((ByteBuffer)((CompletableFuture)this.storage.value(key).thenApplyAsync(pub -> (ByteBuffer)new Concatenation((Publisher<ByteBuffer>)pub).single().blockingGet())).get(), true).bytes();
        }
        catch (ExecutionException err) {
            throw new UncheckedExecutionException((Throwable)err);
        }
    }

    public void delete(Key key) throws InterruptedException {
        try {
            this.storage.delete(key).get();
        }
        catch (ExecutionException err) {
            throw new UncheckedExecutionException((Throwable)err);
        }
    }
}

