/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.fs;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.Transaction;
import com.artipie.asto.fs.FileSystemTransaction;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import wtf.g4s8.rio.file.File;

public final class FileStorage
implements Storage {
    private final Path dir;
    private final ExecutorService exec;

    @Deprecated
    public FileStorage(Path path, Object nothing) {
        this(path);
    }

    public FileStorage(Path path) {
        this(path, ThreadPool.EXEC);
    }

    public FileStorage(Path path, ExecutorService exec) {
        this.dir = path;
        this.exec = exec;
    }

    @Override
    public CompletableFuture<Boolean> exists(Key key) {
        return CompletableFuture.supplyAsync(() -> {
            Path path = this.path(key);
            return Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0]);
        }, this.exec);
    }

    @Override
    public CompletableFuture<Collection<Key>> list(Key prefix) {
        return CompletableFuture.supplyAsync(() -> {
            Collection<Object> keys;
            Path path = this.path(prefix);
            if (Files.exists(path, new LinkOption[0])) {
                int dirnamelen = Key.ROOT.equals(prefix) ? path.toString().length() + 1 : path.toString().length() - prefix.string().length();
                try {
                    keys = Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).map(p -> p.substring(dirnamelen)).map(s -> s.split(FileSystems.getDefault().getSeparator().replace("\\", "\\\\"))).map(Key.From::new).sorted(Comparator.comparing(Key.From::string)).collect(Collectors.toList());
                }
                catch (IOException iex) {
                    throw new UncheckedIOException(iex);
                }
            } else {
                keys = Collections.emptyList();
            }
            Logger.info((Object)this, (String)"Found %d objects by the prefix \"%s\" in %s by %s: %s", (Object[])new Object[]{keys.size(), prefix.string(), this.dir, path, keys});
            return keys;
        }, this.exec);
    }

    @Override
    public CompletableFuture<Void> save(Key key, Content content) {
        return CompletableFuture.supplyAsync(() -> {
            Path file = this.path(key);
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            catch (IOException iex) {
                throw new UncheckedIOException(iex);
            }
            return file;
        }, this.exec).thenCompose(path -> new File(path).write((Publisher)content, this.exec, new OpenOption[0]));
    }

    @Override
    public CompletableFuture<Void> move(Key source, Key destination) {
        return CompletableFuture.supplyAsync(() -> {
            Path dest = this.path(destination);
            dest.getParent().toFile().mkdirs();
            return dest;
        }, this.exec).thenAccept(dst -> {
            try {
                Files.move(this.path(source), dst, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iex) {
                throw new UncheckedIOException(iex);
            }
        });
    }

    @Override
    public CompletableFuture<Void> delete(Key key) {
        return CompletableFuture.runAsync(() -> {
            try {
                Files.delete(this.path(key));
            }
            catch (IOException iex) {
                throw new UncheckedIOException(iex);
            }
        }, this.exec);
    }

    @Override
    public CompletableFuture<Long> size(Key key) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return Files.size(this.path(key));
            }
            catch (IOException iex) {
                throw new UncheckedIOException(iex);
            }
        }, this.exec);
    }

    @Override
    public CompletableFuture<Content> value(Key key) {
        return this.size(key).thenApply(size -> new Content.From((long)size, (Publisher<ByteBuffer>)new File(this.path(key)).content(this.exec)));
    }

    @Override
    public CompletableFuture<Transaction> transaction(List<Key> keys) {
        return CompletableFuture.completedFuture(new FileSystemTransaction(this));
    }

    private Path path(Key key) {
        return Paths.get(this.dir.toString(), key.string());
    }

    private static final class ThreadPool
    implements ThreadFactory {
        static final ExecutorService EXEC = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadPool());
        private final AtomicInteger cnt;

        private ThreadPool() {
            this(new AtomicInteger());
        }

        private ThreadPool(AtomicInteger cnt) {
            this.cnt = cnt;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, String.format("%s-%d", FileStorage.class.getSimpleName(), this.cnt.incrementAndGet()));
        }
    }
}

