/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.s3;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;

final class Bucket {
    private final S3AsyncClient client;
    private final String name;

    Bucket(S3AsyncClient client, String name) {
        this.client = client;
        this.name = name;
    }

    public CompletableFuture<UploadPartResponse> uploadPart(UploadPartRequest request, AsyncRequestBody body) {
        return this.client.uploadPart((UploadPartRequest)request.copy(original -> original.bucket(this.name)), body);
    }

    public CompletableFuture<CompleteMultipartUploadResponse> completeMultipartUpload(CompleteMultipartUploadRequest request) {
        return this.client.completeMultipartUpload((CompleteMultipartUploadRequest)request.copy(original -> original.bucket(this.name)));
    }

    public CompletableFuture<AbortMultipartUploadResponse> abortMultipartUpload(AbortMultipartUploadRequest request) {
        return this.client.abortMultipartUpload((AbortMultipartUploadRequest)request.copy(original -> original.bucket(this.name)));
    }
}

