/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Transaction;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface Storage {
    public CompletableFuture<Boolean> exists(Key var1);

    public CompletableFuture<Collection<Key>> list(Key var1);

    public CompletableFuture<Void> save(Key var1, Content var2);

    public CompletableFuture<Void> move(Key var1, Key var2);

    public CompletableFuture<Long> size(Key var1);

    public CompletableFuture<Content> value(Key var1);

    public CompletableFuture<Void> delete(Key var1);

    public CompletableFuture<Transaction> transaction(List<Key> var1);

    public static abstract class Wrap
    implements Storage {
        private final Storage delegate;

        protected Wrap(Storage delegate) {
            this.delegate = delegate;
        }

        @Override
        public final CompletableFuture<Boolean> exists(Key key) {
            return this.delegate.exists(key);
        }

        @Override
        public final CompletableFuture<Collection<Key>> list(Key prefix) {
            return this.delegate.list(prefix);
        }

        @Override
        public final CompletableFuture<Void> save(Key key, Content content) {
            return this.delegate.save(key, content);
        }

        @Override
        public final CompletableFuture<Void> move(Key source, Key destination) {
            return this.delegate.move(source, destination);
        }

        @Override
        public final CompletableFuture<Long> size(Key key) {
            return this.delegate.size(key);
        }

        @Override
        public final CompletableFuture<Content> value(Key key) {
            return this.delegate.value(key);
        }

        @Override
        public final CompletableFuture<Void> delete(Key key) {
            return this.delegate.delete(key);
        }

        @Override
        public final CompletableFuture<Transaction> transaction(List<Key> keys) {
            return this.delegate.transaction(keys);
        }
    }
}

