/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto;

import io.reactivex.Flowable;
import io.reactivex.Single;
import java.nio.ByteBuffer;
import org.reactivestreams.Publisher;

public class Concatenation {
    private final Publisher<ByteBuffer> source;

    public Concatenation(Publisher<ByteBuffer> source) {
        this.source = source;
    }

    public Single<ByteBuffer> single() {
        return Flowable.fromPublisher(this.source).reduce((Object)ByteBuffer.allocate(0), (left, right) -> {
            ByteBuffer result;
            right.mark();
            if (left.capacity() - left.limit() >= right.limit()) {
                left.position(left.limit());
                left.limit(left.limit() + right.limit());
                result = left.put((ByteBuffer)right);
            } else {
                result = ByteBuffer.allocate(2 * Math.max(left.capacity(), right.capacity())).put((ByteBuffer)left).put((ByteBuffer)right);
            }
            right.reset();
            result.flip();
            return result;
        });
    }
}

