/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.ext;

import com.artipie.asto.Content;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.commons.codec.binary.Hex;
import org.reactivestreams.Publisher;

public final class ContentDigest {
    private final Content content;
    private final Supplier<MessageDigest> digest;
    private final boolean restore;

    public ContentDigest(Publisher<ByteBuffer> content, Supplier<MessageDigest> digest) {
        this(content, digest, false);
    }

    public ContentDigest(Publisher<ByteBuffer> content, Supplier<MessageDigest> digest, boolean restore) {
        this(new Content.From(content), digest, restore);
    }

    public ContentDigest(Content content, Supplier<MessageDigest> digest) {
        this(content, digest, false);
    }

    public ContentDigest(Content content, Supplier<MessageDigest> digest, boolean restore) {
        this.content = content;
        this.digest = digest;
        this.restore = restore;
    }

    public CompletionStage<byte[]> bytes() {
        return (CompletionStage)Flowable.fromPublisher((Publisher)this.content).reduceWith(this.digest::get, (dgst, buf) -> {
            if (this.restore) {
                buf.mark();
            }
            dgst.update((ByteBuffer)buf);
            if (this.restore) {
                buf.reset();
            }
            return dgst;
        }).map(MessageDigest::digest).to(SingleInterop.get());
    }

    public CompletionStage<String> hex() {
        return this.bytes().thenApply(Hex::encodeHexString);
    }
}

