/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto;

import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class OneTimePublisher<T>
implements Publisher<T> {
    private final Publisher<T> original;
    private final AtomicInteger subscribers;

    public OneTimePublisher(Publisher<T> original) {
        this.original = original;
        this.subscribers = new AtomicInteger(0);
    }

    public void subscribe(Subscriber<? super T> sub) {
        int subs = this.subscribers.incrementAndGet();
        if (subs == 1) {
            this.original.subscribe(sub);
        } else {
            String msg = "The subscriber could not be consumed more than once. Failed on #%d attempt";
            sub.onSubscribe(new Subscription(){

                public void request(long cnt) {
                }

                public void cancel() {
                }
            });
            sub.onError((Throwable)new IllegalStateException(String.format("The subscriber could not be consumed more than once. Failed on #%d attempt", subs)));
        }
    }
}

