/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.Transaction;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class SubStorage
implements Storage {
    private final Key prefix;
    private final Storage origin;

    public SubStorage(Key prefix, Storage origin) {
        this.prefix = prefix;
        this.origin = origin;
    }

    @Override
    public CompletableFuture<Boolean> exists(Key key) {
        return this.origin.exists(new PrefixedKed(this.prefix, key));
    }

    @Override
    public CompletableFuture<Collection<Key>> list(Key filter) {
        Pattern ptn = Pattern.compile(String.format("%s/", this.prefix.string()));
        return this.origin.list(new PrefixedKed(this.prefix, filter)).thenApply(keys -> keys.stream().map(key -> new Key.From(ptn.matcher(key.string()).replaceFirst(""))).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Void> save(Key key, Content content) {
        return this.origin.save(new PrefixedKed(this.prefix, key), content);
    }

    @Override
    public CompletableFuture<Void> move(Key source, Key destination) {
        return this.origin.move(new PrefixedKed(this.prefix, source), new PrefixedKed(this.prefix, destination));
    }

    @Override
    public CompletableFuture<Long> size(Key key) {
        return this.origin.size(new PrefixedKed(this.prefix, key));
    }

    @Override
    public CompletableFuture<Content> value(Key key) {
        return this.origin.value(new PrefixedKed(this.prefix, key));
    }

    @Override
    public CompletableFuture<Void> delete(Key key) {
        return this.origin.delete(new PrefixedKed(this.prefix, key));
    }

    @Override
    public CompletableFuture<Transaction> transaction(List<Key> keys) {
        throw new UnsupportedOperationException();
    }

    public static final class PrefixedKed
    extends Key.Wrap {
        public PrefixedKed(Key prefix, Key key) {
            super(new Key.From(prefix, key));
        }
    }
}

