/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.lock;

import com.artipie.asto.lock.Lock;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.internal.InMemoryRetryRegistry;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;

public final class RetryLock
implements Lock {
    private static final int MAX_ATTEMPTS = 3;
    private final ScheduledExecutorService scheduler;
    private final Lock origin;
    private final InMemoryRetryRegistry registry;

    public RetryLock(ScheduledExecutorService scheduler, Lock origin) {
        this(scheduler, origin, new RetryConfig.Builder().maxAttempts(3).intervalFunction(IntervalFunction.ofExponentialBackoff()).build());
    }

    public RetryLock(ScheduledExecutorService scheduler, Lock origin, RetryConfig config) {
        this.scheduler = scheduler;
        this.origin = origin;
        this.registry = new InMemoryRetryRegistry(config);
    }

    @Override
    public CompletionStage<Void> acquire() {
        return this.registry.retry("lock-acquire").executeCompletionStage(this.scheduler, this.origin::acquire);
    }

    @Override
    public CompletionStage<Void> release() {
        return this.registry.retry("lock-release").executeCompletionStage(this.scheduler, this.origin::release);
    }
}

