/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.lock.storage;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.PublisherAs;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

final class Proposals {
    private final Storage storage;
    private final Key target;

    Proposals(Storage storage, Key target) {
        this.storage = storage;
        this.target = target;
    }

    public CompletionStage<Void> create(String uuid, Optional<Instant> expiration) {
        return this.storage.save(this.proposalKey(uuid), expiration.map(instant -> new Content.From(instant.toString().getBytes(StandardCharsets.US_ASCII))).orElse(Content.EMPTY));
    }

    public CompletionStage<Void> checkSingle(String uuid) {
        Instant now = Instant.now();
        Key own = this.proposalKey(uuid);
        return this.storage.list(new RootKey(this.target)).thenCompose(proposals -> CompletableFuture.allOf((CompletableFuture[])proposals.stream().filter(key -> !key.equals(own)).map(proposal -> ((CompletableFuture)((CompletableFuture)this.storage.value((Key)proposal).thenApply(PublisherAs::new)).thenCompose(PublisherAs::asciiString)).thenCompose(expiration -> {
            if (Proposals.isNotExpired(expiration, now)) {
                throw new IllegalStateException(String.join((CharSequence)"\n", "Failed to acquire lock.", String.format("Own: `%s`", own), String.format("Others: %s", proposals.stream().map(Object::toString).map(str -> String.format("`%s`", str)).collect(Collectors.joining(", "))), String.format("Not expired: `%s` `%s`", proposal, expiration)));
            }
            return CompletableFuture.allOf(new CompletableFuture[0]);
        })).toArray(CompletableFuture[]::new)));
    }

    public CompletionStage<Void> delete(String uuid) {
        return this.storage.delete(this.proposalKey(uuid));
    }

    private Key proposalKey(String uuid) {
        return new Key.From((Key)new RootKey(this.target), uuid);
    }

    private static boolean isNotExpired(String instant, Instant now) {
        return instant.isEmpty() || Instant.parse(instant).isAfter(now);
    }

    static class RootKey
    extends Key.Wrap {
        protected RootKey(Key target) {
            super(new Key.From((Key)new Key.From(".artipie-locks"), new Key.From(target, new String[0])));
        }
    }
}

