/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto;

import com.artipie.asto.Storage;
import com.artipie.asto.lock.Lock;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public final class UnderLockOperation<T> {
    private final Lock lock;
    private final Function<Storage, CompletionStage<T>> operation;

    public UnderLockOperation(Lock lock, Function<Storage, CompletionStage<T>> operation) {
        this.lock = lock;
        this.operation = operation;
    }

    public CompletionStage<T> perform(Storage storage) {
        return this.lock.acquire().thenCompose(nothing -> {
            CompletionStage<Object> result;
            try {
                result = this.operation.apply(storage);
            }
            catch (Throwable throwable2) {
                CompletableFuture future = new CompletableFuture();
                future.completeExceptionally(throwable2);
                result = future;
            }
            return result.handle((value, throwable) -> this.lock.release().thenCompose(released -> {
                CompletableFuture<Object> future = new CompletableFuture<Object>();
                if (throwable == null) {
                    future.complete(value);
                } else {
                    future.completeExceptionally((Throwable)throwable);
                }
                return future;
            })).thenCompose(Function.identity());
        });
    }
}

