/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.cache;

import com.artipie.asto.AsyncContent;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.cache.Cache;
import com.artipie.asto.cache.CacheControl;
import com.artipie.asto.rx.RxStorageWrapper;
import com.jcabi.log.Logger;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.SingleSource;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public final class StorageCache
implements Cache {
    private final Storage storage;

    public StorageCache(Storage storage) {
        this.storage = storage;
    }

    @Override
    public CompletionStage<? extends Content> load(Key key, AsyncContent remote, CacheControl control) {
        RxStorageWrapper rxsto = new RxStorageWrapper(this.storage);
        return (CompletionStage)rxsto.exists(key).filter(exists -> exists).flatMapSingleElement(exists -> SingleInterop.fromFuture(control.validate(key, () -> this.storage.value(key)))).filter(valid -> valid).flatMapSingleElement(ignore -> rxsto.value(key)).doOnError(err -> Logger.warn((Object)this, (String)"Failed to read cached item: %[exception]s", (Object[])new Object[]{err})).onErrorComplete().switchIfEmpty((SingleSource)SingleInterop.fromFuture((CompletionStage)remote.get()).flatMapCompletable(content -> rxsto.save(key, new Content.From(content.size(), (Publisher<ByteBuffer>)content))).andThen(rxsto.value(key))).to(SingleInterop.get());
    }
}

