/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.fs;

import hu.akarnokd.rxjava2.interop.CompletableInterop;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.subjects.CompletableSubject;
import io.reactivex.subjects.SingleSubject;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.cqfn.rio.file.File;
import org.reactivestreams.Publisher;

public class RxFile {
    private final Path file;
    private final ExecutorService exec;

    public RxFile(Path file) {
        this(file, Executors.newCachedThreadPool());
    }

    public RxFile(Path file, ExecutorService exec) {
        this.file = file;
        this.exec = exec;
    }

    public Flowable<ByteBuffer> flow() {
        return Flowable.fromPublisher((Publisher)new File(this.file).content(this.exec));
    }

    public Completable save(Flowable<ByteBuffer> flow) {
        return Completable.defer(() -> CompletableInterop.fromFuture((CompletionStage)new File(this.file).write((Publisher)flow, this.exec, new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING})));
    }

    public Completable move(Path target) {
        return Completable.defer(() -> {
            CompletableSubject res = CompletableSubject.create();
            this.exec.submit(() -> {
                try {
                    Files.move(this.file, target, StandardCopyOption.REPLACE_EXISTING);
                    res.onComplete();
                }
                catch (IOException iex) {
                    res.onError((Throwable)iex);
                }
            });
            return res;
        });
    }

    public Completable delete() {
        return Completable.defer(() -> {
            CompletableSubject res = CompletableSubject.create();
            this.exec.submit(() -> {
                try {
                    Files.delete(this.file);
                    res.onComplete();
                }
                catch (IOException iex) {
                    res.onError((Throwable)iex);
                }
            });
            return res;
        });
    }

    public Single<Long> size() {
        return Single.defer(() -> {
            SingleSubject res = SingleSubject.create();
            this.exec.submit(() -> {
                try {
                    res.onSuccess((Object)Files.size(this.file));
                }
                catch (IOException iex) {
                    res.onError((Throwable)iex);
                }
            });
            return res;
        });
    }
}

