/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.fs;

import com.artipie.asto.Remaining;
import io.reactivex.Completable;
import io.reactivex.CompletableEmitter;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.Single;
import io.vertx.core.Vertx;
import io.vertx.core.file.CopyOptions;
import io.vertx.core.file.OpenOptions;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.core.Promise;
import io.vertx.reactivex.core.buffer.Buffer;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import org.reactivestreams.Publisher;

public class VertxRxFile {
    private final Path file;
    private final io.vertx.reactivex.core.Vertx vertx;

    public VertxRxFile(Path file, io.vertx.reactivex.core.Vertx vertx) {
        this.file = file;
        this.vertx = vertx;
    }

    public Flowable<ByteBuffer> flow() {
        return this.vertx.fileSystem().rxOpen(this.file.toString(), new OpenOptions().setRead(true).setWrite(false).setCreate(false)).flatMapPublisher(asyncFile -> {
            Promise promise = Promise.promise();
            Completable completable = Completable.create(emitter -> promise.future().onComplete(event -> {
                if (event.succeeded()) {
                    emitter.onComplete();
                } else {
                    emitter.onError(event.cause());
                }
            }));
            return asyncFile.toFlowable().map(buffer -> ByteBuffer.wrap(buffer.getBytes())).doOnTerminate(() -> asyncFile.rxClose().subscribe(() -> ((Promise)promise).complete())).mergeWith((CompletableSource)completable);
        });
    }

    public Completable save(Flowable<ByteBuffer> flow) {
        return this.vertx.fileSystem().rxOpen(this.file.toString(), new OpenOptions().setRead(false).setCreate(true).setWrite(true).setTruncateExisting(true)).flatMapCompletable(asyncFile -> Completable.create(emitter -> flow.map(buf -> Buffer.buffer((byte[])new Remaining((ByteBuffer)buf).bytes())).onErrorResumeNext(thr -> asyncFile.rxClose().andThen((Publisher)Flowable.error((Throwable)thr))).subscribe((FlowableSubscriber)asyncFile.toSubscriber().onWriteStreamEnd(() -> ((CompletableEmitter)emitter).onComplete()).onWriteStreamError(arg_0 -> ((CompletableEmitter)emitter).onError(arg_0)).onWriteStreamEndError(arg_0 -> ((CompletableEmitter)emitter).onError(arg_0)).onError(arg_0 -> ((CompletableEmitter)emitter).onError(arg_0)))));
    }

    public Completable move(Path target) {
        return this.vertx.fileSystem().rxMove(this.file.toString(), target.toString(), new CopyOptions().setReplaceExisting(true));
    }

    public Completable delete() {
        return this.vertx.fileSystem().rxDelete(this.file.toString());
    }

    public Single<Long> size() {
        return Single.fromCallable(() -> Files.size(this.file)).subscribeOn(RxHelper.blockingScheduler((Vertx)this.vertx.getDelegate()));
    }
}

