/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.asto.s3;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.UnderLockOperation;
import com.artipie.asto.ValueNotFoundException;
import com.artipie.asto.lock.storage.StorageLock;
import com.artipie.asto.s3.Bucket;
import com.artipie.asto.s3.MultipartUpload;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Flowable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.cqfn.rio.file.File;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Object;

public final class S3Storage
implements Storage {
    private static final long MIN_MULTIPART = 0xA00000L;
    private final S3AsyncClient client;
    private final String bucket;
    private final boolean multipart;

    public S3Storage(S3AsyncClient client, String bucket) {
        this(client, bucket, true);
    }

    public S3Storage(S3AsyncClient client, String bucket, boolean multipart) {
        this.client = client;
        this.bucket = bucket;
        this.multipart = multipart;
    }

    @Override
    public CompletableFuture<Boolean> exists(Key key) {
        CompletableFuture<Boolean> exists = new CompletableFuture<Boolean>();
        this.client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucket).key(key.string()).build()).handle((response, throwable) -> {
            if (throwable == null) {
                exists.complete(true);
            } else if (throwable.getCause() instanceof NoSuchKeyException) {
                exists.complete(false);
            } else {
                exists.completeExceptionally((Throwable)throwable);
            }
            return response;
        });
        return exists;
    }

    @Override
    public CompletableFuture<Collection<Key>> list(Key prefix) {
        return this.client.listObjects((ListObjectsRequest)ListObjectsRequest.builder().bucket(this.bucket).prefix(prefix.string()).build()).thenApply(response -> response.contents().stream().map(S3Object::key).map(Key.From::new).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Void> save(Key key, Content content) {
        Content.OneTime onetime = new Content.OneTime(content);
        CompletionStage result = this.multipart ? S3Storage.complementWithSize(onetime, 0xA00000L).thenCompose(updated -> {
            Optional<Long> size = updated.size();
            CompletableFuture<Void> future = size.isPresent() && size.get() < 0xA00000L ? this.put(key, (Content)updated) : this.uploadMultipart(key, (Content)updated);
            return future;
        }) : S3Storage.complementWithSize(onetime).thenCompose(updated -> this.put(key, (Content)updated));
        return result;
    }

    @Override
    public CompletableFuture<Void> move(Key source, Key destination) {
        return this.client.copyObject((CopyObjectRequest)CopyObjectRequest.builder().copySource(String.format("%s/%s", this.bucket, source.string())).bucket(this.bucket).key(destination.string()).build()).thenCompose(copied -> this.client.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucket).key(source.string()).build()).thenCompose(deleted -> CompletableFuture.allOf(new CompletableFuture[0])));
    }

    @Override
    public CompletableFuture<Long> size(Key key) {
        return S3Storage.handleNoSuchKey(key, this.client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucket).key(key.string()).build()).thenApply(HeadObjectResponse::contentLength));
    }

    @Override
    public CompletableFuture<Content> value(Key key) {
        CompletableFuture<Content> promise = new CompletableFuture<Content>();
        this.client.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(this.bucket).key(key.string()).build(), (AsyncResponseTransformer)new ResponseAdapter(promise));
        return S3Storage.handleNoSuchKey(key, promise).thenApply(Content.OneTime::new);
    }

    @Override
    public CompletableFuture<Void> delete(Key key) {
        return this.exists(key).thenCompose(exists -> {
            CompletionStage deleted;
            if (exists.booleanValue()) {
                deleted = this.client.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucket).key(key.string()).build()).thenCompose(response -> CompletableFuture.allOf(new CompletableFuture[0]));
            } else {
                deleted = new CompletableFuture();
                deleted.completeExceptionally(new IllegalArgumentException(String.format("Key does not exist: %s", key)));
            }
            return deleted;
        });
    }

    @Override
    public <T> CompletionStage<T> exclusively(Key key, Function<Storage, CompletionStage<T>> operation) {
        return new UnderLockOperation<T>(new StorageLock(this, key), operation).perform(this);
    }

    private static CompletableFuture<Content> complementWithSize(Content content) {
        return S3Storage.complementWithSize(content, Long.MAX_VALUE);
    }

    private static CompletableFuture<Content> complementWithSize(Content content, long limit) {
        return content.size().map(ignored -> CompletableFuture.completedFuture(content)).orElseGet(() -> S3Storage.cacheInTmpFile(content).thenCompose(tmp -> {
            Flowable cache = Flowable.fromPublisher((Publisher)new File(tmp).content());
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletionStage)cache.map(Buffer::remaining).scanWith(() -> 0L, (sum, item) -> sum + (long)item.intValue()).takeUntil(total -> total >= limit).lastOrError().to(SingleInterop.get())).toCompletableFuture().thenApply(last -> {
                Optional<Object> size = last >= limit ? Optional.empty() : Optional.of(last);
                return size;
            })).thenApply(sizeOpt -> {
                Flowable data = cache.doAfterTerminate(() -> Files.delete(tmp));
                return sizeOpt.map(size -> new Content.From((long)size, (Publisher<ByteBuffer>)data)).orElse(new Content.From((Publisher<ByteBuffer>)data));
            })).handle((value, throwable) -> {
                CompletableFuture<Content> result = new CompletableFuture<Content>();
                if (throwable == null) {
                    result.complete((Content)value);
                } else {
                    try {
                        Files.delete(tmp);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                    result.completeExceptionally((Throwable)throwable);
                }
                return result;
            })).thenCompose(Function.identity());
        }).toCompletableFuture());
    }

    private static CompletionStage<Path> cacheInTmpFile(Publisher<ByteBuffer> publisher) {
        Path tmp;
        try {
            tmp = Files.createTempFile(S3Storage.class.getSimpleName(), ".upload.tmp", new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return new File(tmp).write(publisher, new OpenOption[0]).thenApply(nothing -> tmp);
    }

    private CompletableFuture<Void> put(Key key, Content content) {
        return this.client.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this.bucket).key(key.string()).build(), (AsyncRequestBody)new ContentBody(content)).thenApply(ignored -> null);
    }

    private CompletableFuture<Void> uploadMultipart(Key key, Content content) {
        return ((CompletableFuture)this.client.createMultipartUpload((CreateMultipartUploadRequest)CreateMultipartUploadRequest.builder().bucket(this.bucket).key(key.string()).build()).thenApply(created -> new MultipartUpload(new Bucket(this.client, this.bucket), key, created.uploadId()))).thenCompose(upload -> upload.upload(content).handle((ignored, throwable) -> {
            CompletionStage<Void> finished;
            if (throwable == null) {
                finished = upload.complete();
            } else {
                CompletableFuture<Void> promise = new CompletableFuture<Void>();
                finished = promise;
                upload.abort().whenComplete((result, ex) -> promise.completeExceptionally((Throwable)throwable));
            }
            return finished;
        }).thenCompose(self -> self));
    }

    private static <T> CompletableFuture<T> handleNoSuchKey(Key key, CompletableFuture<T> future) {
        return ((CompletableFuture)future.handle((content, throwable) -> {
            Throwable cause;
            CompletableFuture result = future;
            if (throwable instanceof CompletionException && (cause = throwable.getCause()) instanceof NoSuchKeyException) {
                result = new CompletableFuture();
                result.completeExceptionally(new ValueNotFoundException(key, cause));
            }
            return result;
        })).thenCompose(Function.identity());
    }

    private static class ResponseAdapter
    implements AsyncResponseTransformer<GetObjectResponse, Content> {
        private final CompletableFuture<Content> promise;
        private Long length;

        ResponseAdapter(CompletableFuture<Content> promise) {
            this.promise = promise;
        }

        public CompletableFuture<Content> prepare() {
            return this.promise;
        }

        public void onResponse(GetObjectResponse response) {
            this.length = response.contentLength();
        }

        public void onStream(SdkPublisher<ByteBuffer> publisher) {
            this.promise.complete(new Content.From(Optional.ofNullable(this.length), (Publisher<ByteBuffer>)publisher));
        }

        public void exceptionOccurred(Throwable throwable) {
            this.promise.completeExceptionally(throwable);
        }
    }

    private static class ContentBody
    implements AsyncRequestBody {
        private final Content source;

        ContentBody(Content source) {
            this.source = source;
        }

        public Optional<Long> contentLength() {
            return this.source.size();
        }

        public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
            this.source.subscribe(subscriber);
        }
    }
}

